/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.nature;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.nature.IGradientedLeavesBlock;
import com.sammy.malum.common.block.nature.MalumLeavesBlock;
import com.sammy.malum.registry.common.item.MalumItems;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MalumHangingLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IGradientedLeavesBlock {
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty COLOR = MalumLeavesBlock.COLOR;
    public final Color maxColor;
    public final Color minColor;

    public MalumHangingLeavesBlock(BlockBehaviour.Properties properties, Color maxColor, Color minColor) {
        super(properties);
        this.maxColor = maxColor;
        this.minColor = minColor;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{COLOR, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)COLOR, (Comparable)Integer.valueOf(0));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.equals((Object)Direction.UP) && pFacingState.hasProperty((Property)COLOR)) {
            return super.updateShape((BlockState)pState.setValue((Property)COLOR, (Comparable)((Integer)pFacingState.getValue((Property)COLOR))), pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (stack.getItem().equals(MalumItems.INFERNAL_SPIRIT.get())) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)COLOR, (Comparable)Integer.valueOf(((Integer)state.getValue((Property)COLOR) + 1) % 5)));
            player.swing(handIn);
            player.playSound(SoundEvents.BLAZE_SHOOT, 1.0f, 1.5f + MalumMod.RANDOM.nextFloat() * 0.5f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, hit);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Block block = pLevel.getBlockState(pPos.above()).getBlock();
        return block instanceof LeavesBlock;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public Color getMaxColor() {
        return this.maxColor;
    }

    @Override
    public Color getMinColor() {
        return this.minColor;
    }
}

