/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.gust_igniter;

import com.sammy.malum.common.block.curiosities.gust_igniter.AbstractGustGizmoBlockEntity;
import com.sammy.malum.common.block.curiosities.gust_igniter.GustIgniterBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlockEntity;
import com.sammy.malum.common.block.curiosities.redstone.OpenStateBlockEntity;
import com.sammy.malum.common.data.attachment.WindTunnelData;
import com.sammy.malum.common.item.WindNucleusItem;
import com.sammy.malum.core.handlers.WindTunnelHandler;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import team.lodestar.lodestone.helpers.NBTHelper;

public class GustIgniterBlockEntity
extends AbstractGustGizmoBlockEntity {
    public int strength = 1;
    public int limiter = -1;
    public boolean modified = false;
    public HashSet<BlockPos> windTunnels = new HashSet();
    public AABB windArea;
    public Direction windDirection;

    public GustIgniterBlockEntity(BlockEntityType<? extends GustIgniterBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractGustGizmoBlockEntity>)type, pos, state);
    }

    public GustIgniterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends GustIgniterBlockEntity>)((BlockEntityType)MalumBlockEntities.GUST_IGNITER.get()), pos, state);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.strength = pTag.getInt("strength");
        this.limiter = pTag.getInt("limiter");
        this.modified = pTag.getBoolean("modified");
        this.windTunnels.clear();
        CompoundTag windData = pTag.getCompound("windArea");
        if (!windData.isEmpty()) {
            int amount = windData.getInt("windTunnelAmount");
            for (int i = 0; i < amount; ++i) {
                BlockPos pos = NBTHelper.readBlockPos((CompoundTag)windData.getCompound("windTunnelPosition_" + i));
                if (pos == null) continue;
                this.windTunnels.add(pos);
            }
            this.windArea = new AABB(windData.getDouble("minX"), windData.getDouble("minY"), windData.getDouble("minZ"), windData.getDouble("maxX"), windData.getDouble("maxY"), windData.getDouble("maxZ"));
            this.windDirection = Direction.byName((String)windData.getString("windDirection"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("strength", this.strength);
        tag.putInt("limiter", this.limiter);
        tag.putBoolean("modified", this.modified);
        CompoundTag windData = new CompoundTag();
        if (!this.windTunnels.isEmpty()) {
            windData.putInt("windTunnelAmount", this.windTunnels.size());
            int index = 0;
            for (BlockPos pos : this.windTunnels) {
                windData.put("windTunnelPosition_" + index, (Tag)NBTHelper.saveBlockPos((BlockPos)pos));
                ++index;
            }
        }
        if (this.windArea != null) {
            windData.putDouble("minX", this.windArea.minX);
            windData.putDouble("minY", this.windArea.minY);
            windData.putDouble("minZ", this.windArea.minZ);
            windData.putDouble("maxX", this.windArea.maxX);
            windData.putDouble("maxY", this.windArea.maxY);
            windData.putDouble("maxZ", this.windArea.maxZ);
        }
        if (this.windDirection != null) {
            windData.putString("windDirection", this.windDirection.getName());
        }
        if (!windData.isEmpty()) {
            tag.put("windArea", (Tag)windData);
        }
    }

    @Override
    public void setInfo(AbstractGustGizmoBlockEntity.GustGizmoInfo info) {
        this.strength = info.strength();
        this.modified = info.modified();
    }

    public void onBreak(@Nullable Player player) {
        this.deactivate();
    }

    @Override
    public OpenStateBlockEntity.InboundInfo<? extends OpenStateBlockEntity> resetState() {
        return new AbstractGustGizmoBlockEntity.GustGizmoInfo(this.strength, this.modified);
    }

    @Override
    public void toggleState(ServerLevel level, boolean newValue, OpenStateBlockEntity.InboundInfo<?> inboundInfo) {
        super.toggleState(level, newValue, inboundInfo);
        WindTunnelHandler.modifyTunnels((Level)level, this, b -> (BlockState)b.setValue((Property)WindTunnelBlock.OPEN, (Comparable)Boolean.valueOf(newValue)));
    }

    @Override
    public void serverTick(ServerLevel level) {
        if (this.windArea != null && this.windDirection != null) {
            List affected = level.getEntities(null, this.windArea);
            for (Entity entity : affected) {
                WindTunnelData data;
                if (!WindTunnelHandler.isInArea(entity, this.windArea, this.windDirection, this.windTunnels) || !(data = (WindTunnelData)entity.getData(MalumAttachmentTypes.WIND_TUNNEL_INFO)).addInfluence(this)) continue;
                entity.syncData(MalumAttachmentTypes.WIND_TUNNEL_INFO);
            }
        }
    }

    public void activate(boolean powered) {
        if (WindTunnelHandler.modifyTunnels(this.level, this, b -> (BlockState)b.setValue((Property)WindTunnelBlock.POWERED, (Comparable)Boolean.valueOf(powered)))) {
            return;
        }
        if (!((Boolean)this.getBlockState().getValue((Property)WindTunnelBlock.POWERED)).booleanValue() && powered) {
            this.createWindGust();
        }
    }

    public void deactivate() {
        WindTunnelHandler.modifyTunnels(this.level, this, b -> (BlockState)b.setValue((Property)WindTunnelBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void bind(WindTunnelBlockEntity tunnel) {
        tunnel.bind(this);
        this.windTunnels.add(tunnel.getBlockPos());
    }

    public void unbind(WindTunnelBlockEntity tunnel) {
        tunnel.unbind();
        this.windTunnels.remove(tunnel.getBlockPos());
    }

    public int getTunnelLength() {
        if (this.limiter == -1) {
            return this.strength;
        }
        return Math.min(this.strength, this.limiter);
    }

    public float getTunnelStrength() {
        return Mth.lerp((float)((float)this.getTunnelLength() / 32.0f), (float)0.05f, (float)0.2f);
    }

    public void createWindGust() {
        BlockState state = this.getBlockState();
        BlockPos pos = this.getBlockPos();
        Direction facing = (Direction)state.getValue((Property)GustIgniterBlock.FACING);
        boolean isGlider = this.modified;
        float radius = 1.75f;
        float delta = (float)this.strength / 32.0f;
        float force = (isGlider ? 0.2f : 0.4f) + delta * 0.4f;
        DeferredHolder<MobEffect, MobEffect> appliedEffect = isGlider ? MalumMobEffects.LIFTED : MalumMobEffects.ASCENSION;
        int effectDuration = isGlider ? 100 : 40;
        int effectAmplifier = isGlider ? 2 : 4;
        Vec3 explosionPos = pos.relative(facing).getCenter();
        List<Entity> affectedEntities = WindNucleusItem.getExplosionAffectedEntities(this.level, null, explosionPos, radius);
        this.level.explode(null, null, WindNucleusItem.EXPLOSION_DAMAGE_CALCULATOR, explosionPos.x(), explosionPos.y(), explosionPos.z(), radius, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
        for (Entity entity : affectedEntities) {
            Vec3 velocity = entity.getDeltaMovement();
            double appliedForce = force;
            if (velocity.length() < (double)0.1f) {
                appliedForce *= 1.5;
            }
            if (velocity.y < 0.0) {
                appliedForce += Math.abs(velocity.y);
            }
            Vec3 direction = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
            Vec3 multiplier = new Vec3(0.25, 0.25, 0.25).multiply(Math.abs(direction.x * 4.0), Math.abs(direction.y * 4.0), Math.abs(direction.z * 4.0));
            Vec3 addedVelocity = direction.scale(appliedForce);
            Vec3 result = velocity.add(addedVelocity).multiply(multiplier);
            double limit = Math.min(result.length(), appliedForce) * 2.0;
            entity.setDeltaMovement(result.normalize().scale(limit));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(appliedEffect, effectDuration, effectAmplifier));
            }
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
        }
    }
}

