/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.waveform;

import com.mojang.blaze3d.platform.InputConstants;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.waveform.AbstractValueConfigurationScreen;
import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlockEntity;
import com.sammy.malum.common.payloads.waveform.SpiritDiodeStateUpdatePayload;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.systems.easing.Easing;

public class DiodeValueConfigurationScreen
extends AbstractValueConfigurationScreen {
    private static final int DIAL_SIZE = 64;
    protected static final ResourceLocation DIAL_TEXTURE = MalumMod.malumPath("textures/gui/waveform_artifice/waveform_configuration_dial.png");
    protected static final ResourceLocation DIAL_OVERLAY = MalumMod.malumPath("textures/gui/waveform_artifice/waveform_configuration_dial_overlay.png");
    private final SpiritDiodeBlockEntity diode;
    private SpiritDiodeBlockEntity.TimeIntervalType timeInterval;
    private float displayedAngle;
    private float displayedDelta;
    private int oldAngle;
    private int angle;

    public DiodeValueConfigurationScreen(SpiritDiodeBlockEntity diode) {
        super(DiodeValueConfigurationScreen.getTitleComponent(diode), 244, 124, 64, 64);
        this.diode = diode;
        this.angle = diode.frequency;
        this.timeInterval = diode.type;
    }

    @Override
    protected void notifyServer(boolean isOpen) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SpiritDiodeStateUpdatePayload(this.diode.getBlockPos(), isOpen, new SpiritDiodeBlockEntity.SpiritDiodeInfo(this.timeInterval, this.angle)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void updateMousePosition(double mouseX, double mouseY) {
        double distance = 28.8f;
        double rad = Math.toRadians(-this.angle + 180);
        double newMouseX = (double)this.xDialCenter + Math.sin(rad) * distance;
        double newMouseY = (double)this.yDialCenter + Math.cos(rad) * distance;
        this.setCursor(newMouseX, newMouseY);
    }

    @Override
    protected boolean hasChanged() {
        if (this.oldAngle != this.angle) {
            this.oldAngle = this.angle;
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.disableMouse && DiodeValueConfigurationScreen.isHovering(mouseX, mouseY, this.dialLeft, this.dialTop, 64, 64)) {
            double offsetX = (double)this.xDialCenter - mouseX;
            double offsetY = (double)this.yDialCenter - mouseY;
            this.angle = this.clampAngle(Mth.ceil((double)Math.toDegrees(Math.atan2(offsetX, -offsetY))) + 180);
        }
        this.disableMouse = false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.timeInterval = SpiritDiodeBlockEntity.TimeIntervalType.values()[(this.timeInterval.ordinal() + 1) % 3];
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.angle = this.clampAngle(this.angle + (scrollY > 0.0 ? 1 : -1));
        this.updateMousePosition(mouseX, mouseY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        for (i = 0; i < 3; ++i) {
            MutableComponent guideText = Component.translatable((String)("malum.waveform_artifice.guide." + i));
            int y = this.guiTop + this.screenHeight - 10 * (3 - i);
            guiGraphics.drawString(this.font, (Component)guideText, this.xCenter - this.font.width((FormattedText)guideText) / 2, y, 0xDDDDDD, false);
        }
        this.renderBorderBackground(guiGraphics, this.dialLeft, this.dialTop, 64, 64);
        this.renderDial(guiGraphics, this.dialLeft, this.dialTop);
        for (i = 0; i < 3; ++i) {
            SpiritDiodeBlockEntity.TimeIntervalType type = SpiritDiodeBlockEntity.TimeIntervalType.values()[i];
            this.renderTextWidget(guiGraphics, type.getText(true), this.dialLeft - 5, this.dialTop + 13 * i, type.equals((Object)this.timeInterval), partialTick);
        }
        this.renderBorder(guiGraphics, this.dialLeft, this.dialTop, 64, 64);
        MutableComponent text = Component.literal((String)("" + this.angle));
        float f = (float)this.xDialCenter + 0.5f - (float)this.font.width((FormattedText)text) / 2.0f;
        float f2 = (float)this.yDialCenter + 0.5f;
        Objects.requireNonNull(this.font);
        this.renderText(guiGraphics, (Component)text, f, f2 - 9.0f / 2.0f, true, partialTick);
    }

    @Override
    public void tick() {
        this.displayedAngle = Mth.rotLerp((float)0.2f, (float)this.displayedAngle, (float)this.angle);
        this.displayedDelta = Mth.lerp((float)0.1f, (float)this.displayedDelta, (float)this.angle);
        super.tick();
    }

    public void renderDial(GuiGraphics graphics, int x, int y) {
        this.renderDial(graphics, DIAL_TEXTURE, x, y);
        int angle = Mth.floor((float)this.displayedAngle);
        float delta = this.displayedDelta / 360.0f;
        float range = Easing.SINE_IN_OUT.ease(delta, 40.0f, 90.0f);
        float alpha = Easing.EXPO_IN_OUT.ease(delta, 0.25f, 1.0f);
        this.renderDialOverlay(graphics, DIAL_TEXTURE, x, y, angle, range, alpha);
    }

    public int clampAngle(int angle) {
        int newAngle = angle;
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344)) {
            newAngle = this.oldAngle > angle ? Mth.floor((float)((float)angle / 10.0f)) * 10 : Mth.ceil((float)((float)angle / 10.0f)) * 10;
        }
        if (newAngle > 360) {
            newAngle -= 360;
        } else if (newAngle < 1) {
            newAngle += 360;
        }
        return newAngle;
    }
}

