/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.screens.progression;

import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.MalumScreenHolder;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.progression.ArcanaProgressionScreen;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;

public class ProgressionScreenHolder<T extends AbstractProgressionCodexScreen>
extends MalumScreenHolder<T> {
    public static ProgressionScreenHolder<?> mostRecentScreen;
    protected final Holder<SoundEvent> transitionSound;

    public ProgressionScreenHolder(Supplier<T> screenSupplier, Holder<SoundEvent> transitionSound) {
        super(screenSupplier);
        this.transitionSound = transitionSound;
    }

    public static ProgressionScreenHolder<?> getAppropriateCodexScreen() {
        return mostRecentScreen != null ? mostRecentScreen : ArcanaProgressionScreen.SCREEN;
    }

    public void reopenCodexFromEntryScreen(boolean isVoidTouched, boolean ignoreNextMouseInput) {
        this.openCodex(isVoidTouched, ignoreNextMouseInput);
    }

    public void openCodexViaItem(boolean isVoidTouched) {
        this.openCodex(isVoidTouched, true);
    }

    public void openCodex(boolean isVoidTouched, boolean ignoreNextMouseInput) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen openScreen = minecraft.screen;
        AbstractProgressionCodexScreen screen = (AbstractProgressionCodexScreen)this.getScreen();
        ProgressionScreenHolder.openCodex(screen, isVoidTouched, ignoreNextMouseInput);
        if (openScreen == null) {
            screen.playSweetenedSound((Holder<SoundEvent>)MalumSoundEvents.ARCANA_CODEX_OPEN, 1.25f);
        }
        mostRecentScreen = this;
    }

    public void openCodexViaTransition() {
        AbstractProgressionCodexScreen screen = (AbstractProgressionCodexScreen)this.getScreen();
        Minecraft.getInstance().setScreen((Screen)screen);
        screen.ignoreNextMouseInput = false;
        ++screen.voidFadeoutCounter;
        screen.voidFadeoutTimer = screen.getVoidFadeoutDuration();
        screen.faceOrigin();
        screen.playSound(this.transitionSound, 1.25f, 1.0f);
        mostRecentScreen = this;
    }

    public static void openCodex(AbstractMalumCodexScreen screen, boolean isVoidTouched, boolean ignoreNextMouseInput) {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.setScreen((Screen)screen);
        screen.setVoidTouched(isVoidTouched);
        if (screen instanceof AbstractProgressionCodexScreen) {
            AbstractProgressionCodexScreen progressionScreen = (AbstractProgressionCodexScreen)screen;
            progressionScreen.ignoreNextMouseInput = ignoreNextMouseInput;
            progressionScreen.correctOOBB();
        }
    }
}

