/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.text;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.helper.CodexItemHelper;
import com.sammy.malum.client.screen.codex.helper.CodexTextHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.registry.client.MalumScreenParticles;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.registry.common.particle.LodestoneScreenParticleTypes;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneScreenParticleRenderType;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleType;

public class WeepingWellTextPage
extends BookPage {
    private static final ScreenParticleHolder ITEM_PARTICLES = new ScreenParticleHolder();
    private final String headlineTranslationKey;
    private final String translationKey;
    private final ItemStack stack;

    public WeepingWellTextPage(String headlineTranslationKey, String translationKey, ItemStack stack) {
        super(MalumMod.malumPath("textures/gui/book/pages/weeping_well_page.png"));
        this.headlineTranslationKey = headlineTranslationKey;
        this.translationKey = translationKey;
        this.stack = stack;
    }

    public WeepingWellTextPage(String headlineTranslationKey, String translationKey, Item spirit) {
        this(headlineTranslationKey, translationKey, spirit.getDefaultInstance());
    }

    public String headlineTranslationKey() {
        return "malum.gui.book.entry.page.headline." + this.headlineTranslationKey;
    }

    public String translationKey() {
        return "malum.gui.book.entry.page.text." + this.translationKey;
    }

    @Override
    public void render(CodexEntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource rand = level.random;
        MutableComponent component = Component.translatable((String)this.headlineTranslationKey());
        CodexTextHelper.renderText(guiGraphics, (Component)component, (float)(left + 70) - (float)Minecraft.getInstance().font.width(component.getString()) / 2.0f, top + 5);
        CodexTextHelper.renderWrappingText(guiGraphics, this.translationKey(), (float)(left + 6), (float)(top + 75), 130);
        if (!isRepeat) {
            if (ScreenParticleHandler.canSpawnParticles) {
                ITEM_PARTICLES.tick();
            }
            ITEM_PARTICLES.render();
        }
        CodexItemHelper.renderItem((AbstractMalumCodexScreen)screen, guiGraphics, this.stack, left + 63, top + 38, mouseX, mouseY);
        if (level.getGameTime() % 4L == 0L && ScreenParticleHandler.canSpawnParticles) {
            int lifetime = 100;
            float scale = 1.85f;
            float spin = 6.28f * ((float)level.getGameTime() / 240.0f);
            int x = left + 71;
            int y = top + 46;
            ScreenParticleBuilder.create((ScreenParticleType)LodestoneScreenParticleTypes.STAR, (ScreenParticleHolder)ITEM_PARTICLES).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.02f, (float)0.3f, (float)0.0f).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).setSpinOffset(spin).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)(scale * 1.6f)).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)new Color(78, 17, 43), (Color)new Color(78, 17, 43)).setCoefficient(0.8f).build()).setLifetime(lifetime).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawn((double)x, (double)y);
            ScreenParticleBuilder.create(MalumScreenParticles.SAW, (ScreenParticleHolder)ITEM_PARTICLES).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.02f, (float)0.3f, (float)0.0f).setCoefficient(1.2f).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).setSpinOffset(spin).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)(scale * 0.9f)).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)new Color(255, 133, 155), (Color)new Color(78, 17, 43)).setCoefficient(0.8f).build()).setLifetime(lifetime).setRenderType(LodestoneScreenParticleRenderType.LUMITRANSPARENT).spawn((double)x, (double)y);
        }
    }
}

