/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.objects;

import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.helper.CodexTextHelper;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.CodexEntryScreen;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractSelectableEntryObject<T extends AbstractMalumCodexScreen>
extends BookObject<T> {
    public final BookEntry entry;
    public ItemStack iconStack;
    public Predicate<T> isValid = t -> true;

    public AbstractSelectableEntryObject(BookEntry entry, int posX, int posY, int width, int height) {
        super(posX, posY, width, height);
        this.entry = entry;
        this.iconStack = null;
    }

    public AbstractSelectableEntryObject(EntryReference reference, int posY, int width, int height, int posX) {
        super(posX, posY, width, height);
        this.entry = reference.entry;
        this.iconStack = reference.icon;
    }

    @Override
    public boolean isValid(T screen) {
        return this.isValid.test(screen) && this.entry.shouldShow();
    }

    @Override
    public void renderLate(T screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isHoveredOver && this.entry.hasTooltip()) {
            ((AbstractMalumCodexScreen)((Object)screen)).renderLater(() -> {
                List<Component> tooltip = this.gatherTooltip(screen);
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, tooltip, mouseX, mouseY);
            });
        }
    }

    public List<Component> gatherTooltip(T screen) {
        return new ArrayList<MutableComponent>(List.of(CodexTextHelper.convertToComponent(this.entry.translationKey(), this.entry.titleStyle), CodexTextHelper.convertToComponent(this.entry.descriptionTranslationKey(), this.entry.subtitleStyle)));
    }

    @Override
    public boolean click(T screen, double mouseX, double mouseY) {
        if (this.entry.hasContents()) {
            CodexEntryScreen.openScreen(this.entry);
            return true;
        }
        return false;
    }

    public AbstractSelectableEntryObject<T> setIcon(Supplier<? extends Item> item) {
        return this.setIcon(item.get());
    }

    public AbstractSelectableEntryObject<T> setIcon(Item item) {
        return this.setIcon(item.getDefaultInstance());
    }

    public AbstractSelectableEntryObject<T> setIcon(Holder<GeasEffectType> geas) {
        return this.setIcon(((GeasEffectType)geas.value()).createDefaultStack());
    }

    public AbstractSelectableEntryObject<T> setIcon(ItemStack itemStack) {
        this.iconStack = itemStack;
        return this;
    }

    public AbstractSelectableEntryObject<T> setCondition(Predicate<T> isValid) {
        this.isValid = isValid;
        return this;
    }
}

