/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlock;
import com.sammy.malum.common.block.curiosities.gust_igniter.wind_tunnel.WindTunnelBlockEntity;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.cube.CubeVertexData;
import team.lodestar.lodestone.systems.rendering.rendeertype.LodestoneRenderTypeBuilder;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class WindTunnelRenderer
implements BlockEntityRenderer<WindTunnelBlockEntity> {
    public WindTunnelRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(WindTunnelBlockEntity blockEntity) {
        return true;
    }

    @NotNull
    public AABB getRenderBoundingBox(WindTunnelBlockEntity tunnel) {
        BlockPos pos = tunnel.getBlockPos();
        Direction facing = (Direction)tunnel.getBlockState().getValue((Property)WindTunnelBlock.FACING);
        Vec3 offset = new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ()).scale((double)tunnel.getTunnelLength());
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).expandTowards(offset);
    }

    public void render(WindTunnelBlockEntity tunnel, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tunnel.isActive()) {
            return;
        }
        BlockState state = tunnel.getBlockState();
        Direction facing = (Direction)state.getValue((Property)WindTunnelBlock.FACING);
        int tunnelLength = tunnel.getTunnelLength();
        boolean isInward = tunnel.isModified();
        LodestoneRenderTypeBuilder windTunnel = LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.WIND_COVERAGE_TUNNEL).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT).withModifier(b -> b.setCullState(RenderStateShard.NO_CULL));
        LodestoneRenderTypeBuilder windFlow = LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.WIND_COVERAGE_FLOW).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT).withModifier(b -> b.setCullState(RenderStateShard.NO_CULL));
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        int x = facing.get2DDataValue();
        if (facing.getAxis().isHorizontal()) {
            poseStack.mulPose(Axis.YN.rotationDegrees((float)(x * 90)));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        } else if (facing.equals((Object)Direction.DOWN)) {
            poseStack.mulPose(Axis.XN.rotationDegrees(180.0f));
        } else if (facing.equals((Object)Direction.UP)) {
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        }
        Boolean up = (Boolean)state.getValue((Property)WindTunnelBlock.UP);
        Boolean down = (Boolean)state.getValue((Property)WindTunnelBlock.DOWN);
        Boolean left = (Boolean)state.getValue((Property)WindTunnelBlock.LEFT);
        Boolean right = (Boolean)state.getValue((Property)WindTunnelBlock.RIGHT);
        this.renderBorder(poseStack, up, down, left, right);
        poseStack.translate(0.0f, 0.5f, 0.0f);
        float xStart = -0.4f;
        float xEnd = 0.4f;
        float yStart = 0.0f;
        float yEnd = 1.0f * (float)tunnelLength;
        float zStart = -0.4f;
        float zEnd = 0.4f;
        float offset = 0.1f;
        if (up.booleanValue()) {
            zEnd += offset;
        }
        if (down.booleanValue()) {
            zStart -= offset;
        }
        if (left.booleanValue()) {
            xEnd += offset;
        }
        if (right.booleanValue()) {
            xStart -= offset;
        }
        CubeVertexData windTunnelArea = CubeVertexData.makeCubePositions((float)xStart, (float)xEnd, (float)yStart, (float)yEnd, (float)zStart, (float)zEnd);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        for (int i = 0; i < 4; ++i) {
            Boolean isOccluded = (Boolean)state.getValue((Property)WindTunnelBlock.getDirectionProperty(i));
            if (isOccluded.booleanValue()) continue;
            Direction direction = Direction.from2DDataValue((int)i);
            float offsetDirection = isInward ? -1.0f : 1.0f;
            for (int j = 0; j < 2; ++j) {
                boolean isTunnel = j == 0;
                LodestoneRenderTypeBuilder renderType = isTunnel ? windTunnel : windFlow;
                float interval = isTunnel ? 60.0f : 15.0f;
                float horizontalInterval = interval * 4.0f;
                float uOffset = this.getOffset(tunnel, horizontalInterval, partialTicks) * offsetDirection;
                float vOffset = this.getOffset(tunnel, interval, partialTicks) * offsetDirection;
                float alpha = isTunnel ? 0.35f : 0.9f;
                float u0 = (isInward ? 1.0f : 0.0f) + uOffset;
                float u1 = u0 + 1.0f;
                float v0 = isInward ? -vOffset : vOffset;
                float v1 = v0 + (float)tunnelLength * (isInward ? -1.0f : 1.0f);
                builder.replaceBufferSource(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setAlpha(alpha).setUV(u0, v0, u1, v1).setRenderType(renderType).renderCubeSide(poseStack, windTunnelArea, direction);
            }
        }
        poseStack.popPose();
    }

    private float getOffset(WindTunnelBlockEntity tunnel, float interval, float partialTicks) {
        int tunnelLength = tunnel.getTunnelLength();
        float intensity = (float)tunnelLength / 32.0f;
        float rate = 1.0f + intensity;
        double time = (float)Minecraft.getInstance().level.getGameTime() + partialTicks;
        return (float)(time * (double)rate / (double)interval % (double)interval);
    }

    private void renderBorder(PoseStack poseStack, boolean up, boolean down, boolean left, boolean right) {
        LodestoneRenderTypeBuilder border = LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(MalumRenderTypeTokens.WIND_COVERAGE_BORDER).withUniformHandler(ShaderUniformHandler.LUMITRANSPARENT).withModifier(b -> b.setCullState(RenderStateShard.NO_CULL));
        Vector2f uv = this.getBorderUV(!up, !down, !left, !right);
        float u0 = uv.x;
        float u1 = uv.x + 0.25f;
        float v0 = uv.y;
        float v1 = uv.y + 0.25f;
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.55f, 0.0f);
        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        builder.replaceBufferSource(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setAlpha(0.9f).setUV(u0, v0, u1, v1).setRenderType(border).renderQuad(poseStack, 0.55f);
        poseStack.popPose();
    }

    public Vector2f getBorderUV(boolean up, boolean down, boolean left, boolean right) {
        int v;
        int u;
        if (up && down && left && right) {
            u = 0;
            v = 3;
        } else if (up && down && left) {
            u = 1;
            v = 3;
        } else if (up && down && right) {
            u = 3;
            v = 3;
        } else if (up && left && right) {
            u = 0;
            v = 0;
        } else if (down && left && right) {
            u = 0;
            v = 2;
        } else if (up && down) {
            u = 2;
            v = 3;
        } else if (left && right) {
            u = 0;
            v = 1;
        } else if (up && left) {
            u = 1;
            v = 0;
        } else if (up && right) {
            u = 3;
            v = 0;
        } else if (down && left) {
            u = 1;
            v = 2;
        } else if (down && right) {
            u = 3;
            v = 2;
        } else if (up) {
            u = 2;
            v = 0;
        } else if (down) {
            u = 2;
            v = 2;
        } else if (left) {
            u = 1;
            v = 1;
        } else if (right) {
            u = 3;
            v = 1;
        } else {
            u = 2;
            v = 1;
        }
        return new Vector2f((float)u / 4.0f, (float)v / 4.0f);
    }
}

