/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.common.me.ticker;

import com.glodblock.github.ae2netanalyser.common.me.ticker.GridTickProfiler;
import com.glodblock.github.ae2netanalyser.common.me.ticker.ProfileData;
import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.GlobalPos;

public class ProfilerJob {
    private final long waitingTicks;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final Object2ReferenceMap<GlobalPos, GridTickProfiler> results = new Object2ReferenceOpenHashMap();

    public ProfilerJob(long waitingTicks) {
        this.waitingTicks = waitingTicks;
        this.stopwatch.start();
    }

    public void tick(GlobalPos pos, long ns, long tick) {
        GridTickProfiler profiler = (GridTickProfiler)this.results.get((Object)pos);
        if (profiler == null) {
            profiler = new GridTickProfiler();
            profiler.start();
            this.results.put((Object)pos, (Object)profiler);
        }
        profiler.update(tick, ns);
    }

    public boolean isFinished() {
        return this.waitingTicks <= this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
    }

    public ProfileData generateData() {
        return new ProfileData((ProfileData.ATick[])this.results.entrySet().stream().map(e -> new ProfileData.ATick((GlobalPos)e.getKey(), ((GridTickProfiler)e.getValue()).rate() / 1000.0)).toArray(ProfileData.ATick[]::new));
    }
}

