/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.ae2netanalyser.client.render;

import com.glodblock.github.ae2netanalyser.common.items.ItemNetworkAnalyzer;
import com.glodblock.github.ae2netanalyser.common.me.AnalyserMode;
import com.glodblock.github.ae2netanalyser.common.me.NetworkData;
import com.glodblock.github.glodium.client.render.ColorData;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class NetworkDataHandler {
    private static NetworkData DATA = null;
    private static ItemNetworkAnalyzer.AnalyserConfig CONFIG = new ItemNetworkAnalyzer.AnalyserConfig(AnalyserMode.FULL, 0.4f, (Map<Enum<?>, ColorData>)ItemNetworkAnalyzer.defaultColors);
    private static final ColorData WHITE = new ColorData(1.0f, 1.0f, 1.0f);
    private static boolean needUpdate = true;

    public static void receiveData(NetworkData data) {
        DATA = data != null && data.isCorrupt() ? null : data;
        needUpdate = true;
    }

    @Nullable
    public static NetworkData pullData() {
        return DATA;
    }

    public static boolean update() {
        boolean ret = needUpdate;
        needUpdate = false;
        return ret;
    }

    public static ColorData getColorByConfig(Enum<?> mode) {
        return CONFIG.colors().getOrDefault(mode, WHITE);
    }

    public static float getNodeSize() {
        return CONFIG.nodeSize();
    }

    public static AnalyserMode getMode() {
        return CONFIG.mode();
    }

    public static void updateConfig(ItemNetworkAnalyzer.AnalyserConfig config) {
        CONFIG = config;
        needUpdate = true;
    }
}

