/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.TickingTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class MahoujinProjectorTileEntity
extends TickingTileEntity {
    public ProjectorValues pv = new ProjectorValues();
    public UUID caster = null;

    public MahoujinProjectorTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.projector.get(), p, bs);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.pv.read(compound);
        if (compound.hasUUID("caster")) {
            this.caster = compound.getUUID("caster");
        }
        super.loadAdditional(compound, pRegistries);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.writeToNBT(compound);
        if (this.caster != null) {
            compound.putUUID("caster", this.caster);
        }
        super.saveAdditional(compound, pRegistries);
    }

    public CompoundTag writeToNBT(CompoundTag compound) {
        compound = this.pv.write(compound);
        return compound;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.pv = (ProjectorValues)input.getOrDefault(DataComponents.PROJECTOR_VALUES_COMPONENT, (Object)new ProjectorValues());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.PROJECTOR_VALUES_COMPONENT, (Object)(this.pv == null ? new ProjectorValues() : this.pv));
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, TickingTileEntity blockEntity) {
        if (this.pv.cspeed == 0.0f) {
            this.pv.crotation = 0.0f;
        }
        if (this.pv.corbitspeed == 0.0f) {
            this.pv.corbit = 0.0f;
        }
        if (MTConfig.PROJECTOR_CONTINUES_ROTATE_WHEN_OFF || level != null && !level.hasNeighborSignal(this.worldPosition)) {
            this.pv.crotation += this.pv.cspeed;
            this.pv.crotation %= 360.0f;
            this.pv.cpitch += this.pv.cpitspeed;
            this.pv.cpitch %= 360.0f;
            this.pv.cyaw += this.pv.cyawspeed;
            this.pv.cyaw %= 360.0f;
            this.pv.corbit += this.pv.corbitspeed;
            this.pv.corbit %= 360.0f;
            this.pv.gif_frame += this.pv.gif_speed;
            this.pv.gif_frame %= 100000.0f;
        }
    }

    public static boolean canEdit(Player player, MahoujinProjectorTileEntity projector) {
        return projector.caster == null || player.getUUID().equals(projector.caster) || ContractMahoujinTileEntity.isImmuneToSpell(player.level(), projector.caster, (Entity)player) || player.isCreative();
    }
}

