/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownEntity;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderFallenDownEntity
extends EntityRenderer<FallenDownEntity> {
    public RenderFallenDownEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(FallenDownEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(FallenDownEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderFallenDown(FallenDownEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        matrix.pushPose();
        matrix.translate(x, y, z);
        matrix.translate(0.0, 1.5, 0.0);
        float time = (float)ClientHandler.clientTickCounter * 1.3f;
        float ticksToFullSize = 50.0f;
        float growth = Math.max(0.0f, Math.min(ticksToFullSize, (float)entity.getLife()));
        growth /= ticksToFullSize;
        float rotleft = time;
        float rotright = -time;
        float timeColor = Math.abs((float)(entity.level().getDayTime() % 24000L) - 6000.0f) / 12000.0f;
        float r1 = 0.19215687f;
        float g1 = 0.3529412f;
        float b1 = 0.7058824f;
        float a1 = 1.0f;
        float r2 = 0.27058825f;
        float g2 = 0.7921569f;
        float b2 = 1.0f;
        float a2 = 1.0f;
        float r = r1 + (r2 - r1) * timeColor;
        float g = g1 + (g2 - g1) * timeColor;
        float b = b1 + (b2 - b1) * timeColor;
        float a = a1 + (a2 - a1) * timeColor;
        r = 0.3f;
        g = 0.8f;
        b = 1.0f;
        a = 1.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        int index = 0;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderType type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.mahoujin, 0, false));
        VertexConsumer bb = buffer.getBuffer(type);
        RenderFallenDownEntity.renderPlayerLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        if (growth > 0.0f) {
            RenderFallenDownEntity.renderFirstLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownEntity.renderSecondLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownEntity.renderThirdLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownEntity.renderFourthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownEntity.renderFifthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        if (growth > 0.0f) {
            RenderFallenDownEntity.renderSixthLayer(matrix, rotright, rotleft, buffer, type, r, g, b, a, lightmapX, lightmapY, index, growth);
        }
        matrix.popPose();
    }

    public static void renderPlayerLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        matrix.pushPose();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.6, 90.0f, 2.0f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
        matrix.pushPose();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 1.2, 45.0f, 1.4f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
        matrix.pushPose();
        matrix.translate(0.0, 1.2, 0.0);
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.scale(2.0f, 2.0f, 2.0f);
        VertexConsumer bb = buffer.getBuffer(type);
        RenderFallenDownEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
        buffer.endBatch(type);
        matrix.popPose();
        matrix.pushPose();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.translate(0.0f, 0.0f, 0.0f);
        int num_circles = 4;
        for (int i = 0; i < num_circles; ++i) {
            matrix.pushPose();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(70.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.translate(0.0f, 2.0f, 0.0f);
            matrix.scale(1.0f, 1.0f, 1.0f);
            bb = buffer.getBuffer(type);
            RenderFallenDownEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.endBatch(type);
            matrix.popPose();
        }
        matrix.popPose();
    }

    public static void renderFirstLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        float prevLevel = 10.0f;
        float threshold = 0.0f;
        float endThreshold = 0.5f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        matrix.pushPose();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 4.2, 0.0f, newgrowth * 4.0f, 0.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
        matrix.pushPose();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 4.0, 0.0f, newgrowth * 2.0f, 1.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
        matrix.pushPose();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        matrix.translate(0.0f, 2.0f, 0.0f);
        int num_circles = 8;
        for (int i = 0; i < num_circles; ++i) {
            matrix.pushPose();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(50.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.translate(0.0f, 5.0f, 0.0f);
            VertexConsumer bb = buffer.getBuffer(type);
            matrix.scale(newgrowth * 1.2f, newgrowth * 1.2f, newgrowth * 1.2f);
            if (i % 2 == 0) {
                RenderFallenDownEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            } else {
                t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.0, 45.0f, newgrowth * 0.6f, 0.3f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.endBatch(t2);
                matrix.pushPose();
                matrix.translate(0.0, 0.1, 0.0);
                t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.0, 0.0f, newgrowth * 0.3f, 0.1f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.endBatch(t2);
                matrix.popPose();
                matrix.pushPose();
                matrix.translate(0.0, 0.2, 0.0);
                t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 0.0, 0.0f, newgrowth * 0.4f, 0.1f, 32, lightmapX, lightmapY, r, g, b, a, index++);
                buffer.endBatch(t2);
                matrix.popPose();
                t2 = RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, 0.0, 45.0f, newgrowth * 0.6f, 0.2f, 32, lightmapX, lightmapY, r, g, b, a, index++, RenderUtils.beam);
                buffer.endBatch(t2);
            }
            buffer.endBatch(type);
            matrix.popPose();
        }
        matrix.popPose();
    }

    public static void renderSecondLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        float prevLevel = 10.0f;
        float threshold = 0.0f;
        float endThreshold = 0.5f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        matrix.pushPose();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        RenderType t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0, 0.0f, newgrowth * 6.0f, 0.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
        matrix.pushPose();
        RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
        t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0, 0.0f, newgrowth * 4.0f, 1.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
        buffer.endBatch(t2);
        matrix.popPose();
        matrix.pushPose();
        RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
        matrix.translate(0.0f, newgrowth * 3.0f, 0.0f);
        int num_circles = 6;
        for (int i = 0; i < num_circles; ++i) {
            matrix.pushPose();
            RenderUtils.rotateQ(360 / num_circles * i, 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(60.0f, 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            matrix.translate(0.0f, 9.0f, 0.0f);
            matrix.scale(newgrowth * 4.0f, newgrowth * 4.0f, newgrowth * 4.0f);
            VertexConsumer bb = buffer.getBuffer(type);
            RenderFallenDownEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.endBatch(type);
            matrix.popPose();
        }
        matrix.popPose();
    }

    public static void renderThirdLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float prevLevel = 10.0f;
        float threshold = 0.6f;
        float endThreshold = 0.7f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, prevLevel + 5.0f * newgrowth, 0.0f, 6.0f + newgrowth * 2.0f, newgrowth * 0.8f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, prevLevel + 5.0f * newgrowth, 0.0f, 4.0f, newgrowth * 2.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
    }

    public static void renderFourthLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float prevLevel = 10.0f;
        float threshold = 0.5f;
        float endThreshold = 0.6f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, prevLevel + 2.0f * newgrowth, 0.0f, 2.0f + newgrowth * 2.0f, newgrowth * 2.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 5.0 + 2.5 * (double)newgrowth, 90.0f, 2.0f + newgrowth * 4.0f, newgrowth * 0.6f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
    }

    public static void renderFifthLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float threshold = 0.7f;
        float endThreshold = 0.75f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 15.0f + 3.0f * newgrowth, 90.0f, 8.0f + newgrowth * 6.0f, newgrowth * 1.5f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0f + 4.0f * newgrowth, 90.0f, 4.0f + newgrowth * 7.0f, newgrowth * 1.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
        if (growth > threshold) {
            matrix.pushPose();
            matrix.translate(0.0f, 15.0f + 3.0f * newgrowth, 0.0f);
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            matrix.scale(16.0f + newgrowth * 2.0f, 16.0f + newgrowth * 2.0f, 16.0f + newgrowth * 2.0f);
            VertexConsumer bb = buffer.getBuffer(type);
            RenderFallenDownEntity.renderCircle(bb, matrix, r, g, b, a, lightmapX, lightmapY);
            buffer.endBatch(type);
            matrix.popPose();
        }
    }

    public static void renderSixthLayer(PoseStack matrix, float rotright, float rotleft, MultiBufferSource.BufferSource buffer, RenderType type, float r, float g, float b, float a, int lightmapX, int lightmapY, int index, float growth) {
        RenderType t2;
        float threshold = 0.75f;
        float endThreshold = 0.8f;
        float newgrowth = (growth - threshold) / (endThreshold - threshold);
        newgrowth = Math.min(newgrowth, 1.0f);
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 10.0f + 3.0f * newgrowth, 0.0f, 8.0f + newgrowth * 8.0f, newgrowth * 3.0f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotleft, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 18.0f + 3.0f * newgrowth, 0.0f, 9.0f + newgrowth * 12.0f, newgrowth * 3.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
        if (growth > threshold) {
            matrix.pushPose();
            RenderUtils.rotateQ(rotright, 0.0f, 1.0f, 0.0f, matrix);
            t2 = RenderUtils.renderRingCull(matrix, (MultiBufferSource)buffer, 18.0f + 3.0f * newgrowth, 0.0f, 9.0f + newgrowth * 4.5f, newgrowth * 5.2f, 128, lightmapX, lightmapY, r, g, b, a, index++);
            buffer.endBatch(t2);
            matrix.popPose();
        }
    }

    public static void renderCircle(VertexConsumer bb, PoseStack matrix, float r, float g, float b, float a, int lightmapX, int lightmapY) {
        Matrix4f m = matrix.last().pose();
        bb.addVertex(m, -0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, -0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, 0.5f).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(lightmapX, lightmapY);
        bb.addVertex(m, 0.5f, 0.0f, -0.5f).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(lightmapX, lightmapY);
    }
}

