/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.dataattachments.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.entity.mahoujin.AuthorityMahoujinEntity;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.AuthorityPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ExtraPotionInterface;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ScrollPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BorrowedAuthorityPotion
extends ScrollPotion
implements ExtraPotionInterface {
    public static final ResourceLocation speedauthority = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"authority_speed");

    protected BorrowedAuthorityPotion() {
        super(ModEffects.getColorNumber(255, 255, 51));
    }

    public static void authorityPlayerTick(Player player) {
        Level world = player.level();
        if (!world.isClientSide) {
            if (player.hasEffect(ModEffects.BORROWED_AUTHORITY)) {
                if (!player.isDiscrete()) {
                    AttributeModifier a = new AttributeModifier(speedauthority, MTConfig.AUTHORITY_SPEED_MULTIPLIER, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
                    if (!player.getAttribute(Attributes.MOVEMENT_SPEED).hasModifier(speedauthority)) {
                        player.getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(a);
                    }
                } else {
                    player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(speedauthority);
                }
            } else {
                player.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(speedauthority);
            }
        }
    }

    public static void authorityLivingUpdate(LivingEntity entity) {
        ILivingMahou mahou;
        int offspeed = 5;
        if (entity != null && (mahou = Utils.getLivingMahou(entity)) != null && mahou.getAuthorityHit()) {
            Vec3 xyz = entity.getDeltaMovement();
            if (!entity.level().isClientSide) {
                if (xyz.lengthSqr() < (double)(offspeed * offspeed)) {
                    mahou.setAuthorityHit(false);
                    entity.noPhysics = false;
                } else {
                    entity.hasImpulse = true;
                    entity.setOnGround(false);
                    entity.noPhysics = true;
                    double factor1 = MTConfig.AUTHORITY_NORMAL_SLOW_DOWN_FACTOR;
                    xyz = xyz.scale(factor1);
                    entity.setDeltaMovement(xyz);
                    if (ServerHandler.tickCounter % 2L == 0L) {
                        AuthorityMahoujinEntity ame = new AuthorityMahoujinEntity(entity.level(), entity, 1.0f, 1.0f, 0.2f, 0.95f, 4.0f);
                        ame.setRotationSpeed(0.2f);
                        entity.level().addFreshEntity((Entity)ame);
                    }
                    Vec3 epos = entity.position();
                    Vec3 motionV = entity.getDeltaMovement();
                    int destroyed = 0;
                    ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
                    int i = 0;
                    while ((double)i < motionV.length()) {
                        BlockPos nextTick = Utils.toBlockPos(epos.add(motionV.normalize().scale((double)i)));
                        Stream poss = BlockPos.betweenClosedStream((BlockPos)nextTick.offset(-1, -1, -1), (BlockPos)nextTick.offset(1, 1, 1));
                        poss.forEach(tmp -> {
                            BlockPos p = new BlockPos(tmp.getX(), tmp.getY(), tmp.getZ());
                            BlockState bs = entity.level().getBlockState(p);
                            if (!Utils.isBlockAir(entity.level(), p) && (double)bs.getBlock().getExplosionResistance(bs, (BlockGetter)entity.level(), p, null) <= (double)MTConfig.AUTHORITY_BLOCK_RESISTANCE_LIMIT + 0.01 && entity.level().getBlockEntity(p) == null) {
                                affected.add(p);
                            } else if (!Utils.isBlockAir(entity.level(), p)) {
                                entity.noPhysics = false;
                            }
                        });
                        destroyed = affected.size();
                        ++i;
                    }
                    EffectUtil.tryFakeExplosion(EffectUtil.createFakeExplosion((Entity)entity, null, entity.position(), affected), affected, (Entity)entity, null, "borrowed_authority", MTConfig.AUTHORITY_DROPS_BLOCKS, new ArrayList<Entity>());
                    if (destroyed > 0) {
                        double factor = MTConfig.AUTHORITY_BREAK_SLOW_DOWN_FACTOR;
                        xyz.scale(factor);
                    }
                    entity.setDeltaMovement(xyz);
                }
            }
        }
    }

    public static void authorityAttackFromPlayer(Player player, Entity target) {
        double damage = MTConfig.AUTHORITY_DAMAGE_TO_OTHER;
        double damageToSelf = MTConfig.AUTHORITY_DAMAGE_TO_SELF;
        if (player.hasEffect(ModEffects.BORROWED_AUTHORITY) && !player.level().isClientSide && target != null) {
            Vec3 pv = player.position();
            Vec3 look = pv.subtract(target.position());
            MandatoryFun.completeFunReq(player, MandatoryFun.FUN_REQS.BORROWED_AUTHORITY_PUNCH);
            BorrowedAuthorityPotion.borrowedAuthorityBoop(target, 16.0f, look.x, look.y, look.z, 2.0);
            ILivingMahou targetMahou = Utils.getLivingMahou((LivingEntity)target);
            if (!EffectUtil.hasBuff((LivingEntity)target, ModEffects.BA_COOLDOWN)) {
                targetMahou.setAuthorityHit(true);
                target.hurt(player.damageSources().playerAttack(player), (float)damage);
                player.hurt(player.damageSources().playerAttack(player), (float)damageToSelf);
                AuthorityMahoujinEntity ame = new AuthorityMahoujinEntity(target.level(), (LivingEntity)target, player.getEyePosition(1.0f), player.getLookAngle(), 1.0f, 1.0f, 0.2f, 0.95f, 4.0f);
                ame.setRotationSpeed(0.2f);
                target.level().addFreshEntity((Entity)ame);
                Vec3 epos = target.position();
                Vec3 motionV = target.getDeltaMovement();
                BorrowedAuthorityPotion.makeHoleWithTarget(target.level(), target, epos, motionV);
                EffectUtil.buff((LivingEntity)target, ModEffects.BA_COOLDOWN, false, 8);
            }
        }
    }

    public static void makeHoleWithTarget(Level world, Entity target, Vec3 epos, Vec3 motionV) {
        ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i < motionV.length()) {
            BlockPos nextTick = Utils.toBlockPos(epos.add(motionV.normalize().scale((double)i)));
            Stream poss = BlockPos.betweenClosedStream((BlockPos)nextTick.offset(-1, -1, -1), (BlockPos)nextTick.offset(1, 1, 1));
            poss.forEach(tmp -> {
                BlockPos p = new BlockPos(tmp.getX(), tmp.getY(), tmp.getZ());
                BlockState bs = world.getBlockState(p);
                if (!Utils.isBlockAir(world, p) && (double)bs.getBlock().getExplosionResistance(bs, (BlockGetter)world, p, null) <= (double)MTConfig.AUTHORITY_BLOCK_RESISTANCE_LIMIT + 0.01 && target.level().getBlockEntity(p) == null) {
                    affected.add(p);
                }
            });
            ++i;
        }
        EffectUtil.tryFakeExplosion(EffectUtil.createFakeExplosion(target, null, target.position(), affected), affected, target, null, "borrowed_authority", MTConfig.AUTHORITY_DROPS_BLOCKS, new ArrayList<Entity>());
    }

    public static void borrowedAuthorityBoop(Entity entity, float strength, double x, double y, double z, double yboost) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = entity.getDeltaMovement();
        double motionX = motion.x;
        double motionY = motion.y;
        double motionZ = motion.z;
        motionX = 0.0;
        motionZ = 0.0;
        motionY = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.hurtMarked = true;
        if (entity.onGround()) {
            motionY += yboost;
        }
        entity.setDeltaMovement(motionX, motionY, motionZ);
    }

    @Override
    public void onRemove(LivingEntity livingEntity, MobEffect effect) {
        BorrowedAuthorityPotion.notifyNotAuthority(livingEntity);
    }

    @Override
    public void onAdd(LivingEntity livingEntity, MobEffect effect) {
        BorrowedAuthorityPotion.notifyIfAuthority(livingEntity);
    }

    public static void notifyIfAuthority(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.BORROWED_AUTHORITY)) {
            BorrowedAuthorityPotion.notifyTracking(lst, true, e.level());
        }
    }

    public static void notifyNotAuthority(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        BorrowedAuthorityPotion.notifyTracking(lst, false, e.level());
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new AuthorityPacket(e.getId(), r));
            }
        }
    }
}

