/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class SelectiveDisplacementPacket
implements CustomPacketPayload {
    int id1 = 0;
    int id2 = 0;
    public static final StreamCodec<ByteBuf, SelectiveDisplacementPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.id1, (StreamCodec)ByteBufCodecs.INT, p -> p.id2, SelectiveDisplacementPacket::new);

    public SelectiveDisplacementPacket(int i, int i2) {
        this.id1 = i;
        this.id2 = i2;
    }

    public static void handle(SelectiveDisplacementPacket message, IPayloadContext context) {
        if (context.player() instanceof ServerPlayer) {
            SelectiveDisplacementPacket.handleAbilitySelectiveDisplacement((ServerPlayer)context.player(), message.id1, message.id2);
        }
    }

    public static void handleAbilitySelectiveDisplacement(ServerPlayer player, int id, int id2) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT) && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN) && id != 0) {
            Entity e = player.level().getEntity(id);
            Object e2 = player;
            e2 = id2 != 0 && id2 != id ? player.level().getEntity(id2) : player;
            if (e != null && e2 != null && e != e2 && EffectUtil.getDimension(e.level()) == EffectUtil.getDimension(e2.level())) {
                double x = e.getX();
                double y = e.getY();
                double z = e.getZ();
                double x2 = e2.getX();
                double y2 = e2.getY();
                double z2 = e2.getZ();
                if (e2.getPassengers().size() > 0) {
                    e2.ejectPassengers();
                }
                if (e.getPassengers().size() > 0) {
                    e.ejectPassengers();
                }
                MahouTsukaiTeleporter.teleport(e, e2.getX(), e2.getY(), e2.getZ(), EffectUtil.getDimension(e.level()));
                Vec3 facing = new Vec3(x2, y2, z2).subtract(new Vec3(x, y, z));
                facing = facing.normalize();
                float pitch = (float)Math.asin(-facing.y);
                float yaw = (float)Math.atan2(facing.x, facing.z);
                if (e2 instanceof LivingEntity) {
                    e2.yRot = EffectUtil.toDegrees(-yaw);
                    e2.xRot = EffectUtil.toDegrees(pitch);
                }
                facing = facing.multiply(-1.0, -1.0, -1.0);
                float pitch2 = (float)Math.asin(-facing.y);
                float yaw2 = (float)Math.atan2(facing.x, facing.z);
                if (e instanceof LivingEntity) {
                    e.yRot = EffectUtil.toDegrees(-yaw2);
                    e.xRot = EffectUtil.toDegrees(pitch2);
                }
                MahouTsukaiTeleporter.teleport((Entity)e2, x, y, z, EffectUtil.getDimension(e2.level()));
                e2.hurtMarked = true;
                e.hurtMarked = true;
                e2.setOnGround(false);
                e.setOnGround(false);
                ServerPlayer target = null;
                if (e == player) {
                    target = e2;
                }
                if (e2 == player) {
                    target = e;
                }
                if (target != null && ContractMahoujinTileEntity.isImmuneToSpell(player.level(), player.getUUID(), (Entity)target)) {
                    ((MahouTrigger)((Object)ModTriggers.BOOGIE_WOOGIE.get())).trigger(player);
                }
                if (e != player && e2 != player) {
                    MandatoryFun.completeFunReq((Player)player, MandatoryFun.FUN_REQS.SWAP_TWO_THINGS);
                }
                EffectUtil.buff((LivingEntity)player, ModEffects.SELECTIVE_DISPLACEMENT_COOLDOWN, false, MTConfig.SELECTIVE_DISPLACEMENT_COOLDOWN);
            }
        }
    }

    public CustomPacketPayload.Type<SelectiveDisplacementPacket> type() {
        return MahouPackets.SELECTIVE_DISPLACEMENT_TYPE;
    }
}

