/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.Utils;

public class SavePagePacket
implements CustomPacketPayload {
    int page;
    public static final StreamCodec<ByteBuf, SavePagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.page, SavePagePacket::new);

    public SavePagePacket(int page) {
        this.page = page;
    }

    public static void handle(SavePagePacket message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        IMahou mahou = Utils.getPlayerMahou((Player)player);
        mahou.setGuidePage(message.page);
        PlayerManaManager.updateClientMahou(player, mahou);
    }

    public CustomPacketPayload.Type<SavePagePacket> type() {
        return MahouPackets.SAVE_PAGE_TYPE;
    }
}

