/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.rulebreaker.RuleBreaker;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.tile.secret.ProbabilityAlterMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ProbabilityAlterSpellScroll
extends SpellScroll {
    public ProbabilityAlterSpellScroll() {
        super("probability_alter");
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.RULE_BREAKER_MANA_COST;
    }

    @Override
    public boolean doSpell(Player user, ScrollMahou scrollMahou, ItemStack s) {
        int x;
        if (scrollMahou != null && (x = ProbabilityAlterSpellScroll.findTilesInRangeWithItemOnTop(user)) > 1) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.ruleBreaker.get());
            RuleBreaker.setModulus(stack, x);
            RuleBreaker.setDesignation(stack, 0);
            stack.setCount(1);
            user.addItem(stack);
            return true;
        }
        return false;
    }

    public static int findTilesInRangeWithItemOnTop(Player player) {
        ArrayList<BlockPos> lst = Utils.findTilesInRange((LivingEntity)player, MTConfig.RULE_BREAKER_RANGE, a -> a instanceof ProbabilityAlterMahoujinTileEntity);
        ArrayList<ItemEntity> toRemove = new ArrayList<ItemEntity>();
        for (BlockPos p : lst) {
            BlockEntity te = player.level().getBlockEntity(p);
            if (!(te instanceof ProbabilityAlterMahoujinTileEntity)) continue;
            List es = player.level().getEntitiesOfClass(ItemEntity.class, new AABB((double)p.getX(), (double)p.getY(), (double)p.getZ(), (double)(p.getX() + 1), (double)(p.getY() + 1), (double)(p.getZ() + 1)));
            for (ItemEntity item : es) {
                if (!EffectUtil.inItemBlacklist(item.getItem().getItem(), MTConfig.RULE_BREAKER_ITEM_WHITELIST, player.level())) continue;
                toRemove.add(item);
            }
        }
        int ret = 0;
        for (ItemEntity e : toRemove) {
            e.getItem().shrink(1);
            ++ret;
        }
        return ret;
    }
}

