/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.jousting;

import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import stepsword.jousting.DataComponents;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.MahouRegistry;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.lance.LanceMahou;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.integration.jousting.JoustingProxy;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.lance.Rhongomyniad;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.render.item.MagicalItemRender;
import stepsword.mahoutsukai.render.item.RhongomyniadRenderer;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class JoustingLoadedProxy
extends JoustingProxy {
    @Override
    public void registerItems(RegisterEvent.RegisterHelper<Item> helper) {
        ModItems.rhongomyniad = new Rhongomyniad();
        helper.register(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)MahouRegistry.ITEM_RHONGOMYNIAD), (Object)ModItems.rhongomyniad);
    }

    @Override
    public void addToCreativeTab(BuildCreativeModeTabContentsEvent output) {
        output.accept((ItemLike)ModItems.rhongomyniad);
    }

    @Override
    public void powerConsolidation(LevelTickEvent event, ItemEntity item, List<ItemEntity> toDelete, List<WeaponProjectileEntity> toSpawn, int manaCost) {
        if (item.getItem().getItem() instanceof ItemLance && PowerConsolidationSpellEffect.isItemAllowed(item.getItem(), event.getLevel())) {
            boolean inMurkyWater = Utils.isInMurkyWater((Entity)item);
            boolean isAllowed = PowerConsolidationSpellEffect.isItemAllowed(item.getItem(), event.getLevel());
            boolean isEnchanted = item.getItem().isEnchanted();
            boolean hasOwner = item.thrower != null && item.getOwner() instanceof Player;
            double rhongomyniadNerf = MTConfig.RHONGOMYNIAD_NERF_FACTOR;
            if (!hasOwner && inMurkyWater) {
                PlayerHelp.sendHelpMessageNearby(item.blockPosition(), item.level(), PlayerHelp.Message.RHONGOMYNIAD_NO_OWNER);
            }
            if (hasOwner && inMurkyWater) {
                Player player = (Player)item.getOwner();
                if (isAllowed) {
                    if (isEnchanted) {
                        ConcurrentSet connected = new ConcurrentSet();
                        boolean lt = PowerConsolidationSpellEffect.lakeThreshhold(item.blockPosition(), (ConcurrentSet<BlockPos>)connected, event.getLevel());
                        if (lt) {
                            if (PlayerManaManager.hasMana(player, manaCost)) {
                                BlockPos p = PowerConsolidationSpellEffect.findCenter((ConcurrentSet<BlockPos>)connected);
                                if (!Utils.isBlockAir(event.getLevel(), p)) {
                                    p = p.below();
                                }
                                ItemStack stack = new ItemStack((ItemLike)ModItems.rhongomyniad);
                                LanceMahou mahou = Utils.getLanceMahou(stack);
                                float damage = Rhongomyniad.simulateHit(item.getItem(), event.getLevel());
                                ItemStack stackCopy = item.getItem().copy();
                                Utils.removeAllEnchants(stackCopy);
                                float damageWithoutEnchant = Rhongomyniad.simulateHit(stackCopy, event.getLevel());
                                damage = (float)((double)damage - rhongomyniadNerf * (double)(damage - damageWithoutEnchant));
                                mahou.setAttackDamage(damage -= 1.0f);
                                mahou.setWeight((float)(((ItemLance)item.getItem().getItem()).getWeight(item.getItem()) - (double)0.02f));
                                Utils.setLanceMahou(stack, mahou);
                                Utils.debug("Advancement Time");
                                WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.getLevel(), p.getX(), p.getY(), p.getZ(), stack);
                                wpe.setDeltaMovement(0.0, -1.0, 0.0);
                                wpe.setOwner((Entity)player);
                                toSpawn.add(wpe);
                                toDelete.add(item);
                            } else {
                                PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.NOT_ENOUGH_MANA);
                            }
                        } else {
                            PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.CALIBURN_LAKE_TOO_SMALL);
                        }
                    } else {
                        PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.RHONGOMYNIAD_NOT_ENCHANTED);
                    }
                } else {
                    PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.RHONGOMYNIAD_LANCE_BANNED);
                }
            }
        }
    }

    @Override
    public void render(ItemStack stack, boolean m) {
        stack.set((Supplier)DataComponents.SHOULD_RENDER_COMPONENT, (Object)m);
    }

    @Override
    public boolean shouldRender(ItemStack stack) {
        if (stack.has((Supplier)DataComponents.SHOULD_RENDER_COMPONENT)) {
            return Boolean.TRUE.equals(stack.get((Supplier)DataComponents.SHOULD_RENDER_COMPONENT));
        }
        return true;
    }

    @Override
    public boolean treasuryProjection(Item i) {
        return i instanceof ItemLance;
    }

    @Override
    public DeferredHolder<Item, Item> getRhongo() {
        return ModItems.ITEMS.register(MahouRegistry.ITEM_RHONGOMYNIAD, Rhongomyniad::new);
    }

    @Override
    public void registerRenderer(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new MagicalItemRender(RhongomyniadRenderer::new), new Item[]{ModItems.rhongomyniad});
    }
}

