/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.butterfly;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.butterfly.SerializableBlockBreak;
import stepsword.mahoutsukai.entity.butterfly.SerializableBlockPlace;
import stepsword.mahoutsukai.entity.butterfly.SerializableHit;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ButterflyEntity
extends Entity {
    public static final String entityName = "butterfly_entity";
    private static final String TAG_SIZE = "MAHOUTSUKAI_SIZE";
    private static final String TAG_RANDOM_SEED = "MAHOUTSUKAI_RANDOM_SEED";
    private static final String TAG_PLACE_BLOCK = "MAHOUTSUKAI_PLACE_BLOCK";
    private static final String TAG_BREAK_BLOCK = "MAHOUTSUKAI_BREAK_BLOCK";
    private static final String TAG_HIT = "MAHOUTSUKAI_HIT";
    private static final String TAG_DYING = "MAHOUTSUKAI_DYING";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_EFFECT = "MAHOUTSUKAI_EFFECT";
    public EFFECT effect = EFFECT.NONE;
    boolean colorstarted = false;
    int dying = 0;
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> RANDOM_SEED = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DYING = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> CASTER = SynchedEntityData.defineId(ButterflyEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private AABB zero = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public AABB aabb;
    public BlockPos origPos;
    public BlockPos origPos1;
    public float angle = 0.0f;
    public float prevangle = 0.0f;
    public float wingspeed = 0.0f;
    public float topstop = 89.0f;
    public float bottomstop = -29.0f;
    public float defaultSize = 0.3f;
    public Random rng;
    public float[][] colors = new float[6][4];
    public float[][] targets = new float[6][4];
    SerializableBlockPlace placeBlock;
    SerializableBlockBreak breakBlock;
    SerializableHit hit;

    public ButterflyEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public ButterflyEntity(Level world) {
        super((EntityType)ModEntities.BUTTERFLY.get(), world);
        this.noCulling = true;
    }

    public ButterflyEntity(Level world, Player caster, int seed, float size) {
        this(world);
        this.setCasterUUID(caster.getUUID());
        this.setSize(size);
        this.setSeed(seed);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIZE, (Object)Float.valueOf(this.defaultSize));
        builder.define(RANDOM_SEED, (Object)812389532);
        builder.define(DYING, (Object)false);
        builder.define(CASTER, Optional.empty());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.yRotO = this.yRot;
            if (this.rng == null) {
                this.rng = new Random(this.getSeed());
            }
            if (this.getSize() == 0.0f) {
                this.setSize(this.defaultSize);
            }
            if (!this.getDying()) {
                this.initColor();
                this.flap();
                this.colorUpdate(1.0f, true);
            } else {
                if (this.dying == 0) {
                    for (int i = 0; i < this.targets.length; ++i) {
                        this.targets[i][0] = 255.0f;
                        this.targets[i][1] = 255.0f;
                        this.targets[i][2] = 255.0f;
                    }
                }
                this.prevangle = this.angle;
                ++this.dying;
                this.colorUpdate(10.0f, false);
            }
        } else {
            if (this.getDying()) {
                ++this.dying;
                if (this.dying > 25) {
                    this.discard();
                }
            }
            if (this.origPos == null) {
                this.origPos = this.blockPosition();
                this.origPos1 = this.origPos.offset(1, 1, 1);
            }
            this.move();
        }
    }

    public void move() {
        this.xRot = -30.0f;
        this.yRot %= 360.0f;
        Vec3 motion = this.getDeltaMovement();
        double motionX = motion.x;
        double motionY = motion.y;
        double motionZ = motion.z;
        Vec3 pos = this.position();
        motionX = -0.01 * this.getLookAngle().x;
        motionZ = 0.01 * this.getLookAngle().z;
        if (pos.x() - (double)this.origPos.getX() < 0.1 || pos.z() - (double)this.origPos.getZ() < 0.1 || (double)this.origPos1.getX() - pos.x() < 0.1 || (double)this.origPos1.getZ() - pos.z() < 0.1) {
            Vec3 v = EffectUtil.fromBlockPos(this.origPos).add(0.5, 0.5, 0.5);
            Vec3 moveTo = v.subtract(this.position());
            float yawto = EffectUtil.toDegrees((float)Math.atan2(moveTo.x, moveTo.z));
            float diff = this.rotateTowards(yawto);
            this.yRot += diff;
            this.yRot = Mth.wrapDegrees((float)this.yRot);
        }
        if (pos.y() - (double)this.origPos.getY() < 0.1) {
            motionY = 0.02;
        } else {
            if ((double)this.origPos1.getY() - pos.y() < 0.1) {
                motionY = -0.02;
            } else if (ServerHandler.tickCounter % 30L == 0L) {
                motionY = (double)this.random.nextFloat() * 0.04 - 0.02;
            }
            if (!this.getDying()) {
                List lst;
                if (this.aabb == null && this.origPos != null && this.origPos1 != null) {
                    double n = 0.25;
                    this.aabb = new AABB((double)this.origPos.getX() + n, (double)this.origPos.getY() + n, (double)this.origPos.getZ() + n, (double)this.origPos1.getX() - n, (double)this.origPos1.getY() - n, (double)this.origPos1.getZ() - n);
                }
                if ((lst = this.level().getEntitiesOfClass(Entity.class, this.aabb)).size() > 0) {
                    Entity e;
                    Iterator iterator = lst.iterator();
                    while (iterator.hasNext() && ((e = (Entity)iterator.next()) == this || !this.collide(e))) {
                    }
                }
            }
        }
        this.setDeltaMovement(motionX, motionY, motionZ);
        Vec3 newpos = this.position().add(this.getDeltaMovement());
        this.setPos(newpos.x, newpos.y, newpos.z);
    }

    public float rotateTowards(float yaw) {
        return Math.abs((yaw - this.yRot) % 360.0f) < 10.0f ? this.random.nextFloat() * 2.0f - 1.0f : 5.0f;
    }

    public void startDying() {
        this.setDying(true);
    }

    public void initColor() {
        if (!this.colorstarted) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.colors[i][j] = this.rng.nextInt(255);
                    this.targets[i][j] = this.colors[i][j];
                }
            }
            this.colorstarted = true;
        }
    }

    public void colorUpdate(float step, boolean reroll) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                float f = this.colors[i][j];
                float f1 = this.targets[i][j];
                if (f == f1) {
                    if (!reroll) continue;
                    this.targets[i][j] = this.rng.nextInt(255);
                    continue;
                }
                if (f > f1) {
                    float[] fArray = this.colors[i];
                    int n = j;
                    fArray[n] = fArray[n] - Math.min(step, f - f1);
                    continue;
                }
                if (!(f < f1)) continue;
                float[] fArray = this.colors[i];
                int n = j;
                fArray[n] = fArray[n] + Math.min(step, f1 - f);
            }
        }
    }

    public void flap() {
        this.prevangle = this.angle;
        float wingrange = 120.0f;
        float fastestFlap = 5.0f;
        float slowestFlap = 15.0f;
        float slowestSpeed = wingrange / slowestFlap;
        float fastestSpeed = wingrange / fastestFlap;
        this.angle += this.wingspeed;
        if (this.angle <= this.bottomstop || this.wingspeed == 0.0f) {
            this.wingspeed = this.rng.nextFloat() * (fastestSpeed - slowestSpeed) + slowestSpeed;
            this.topstop = 90.0f - this.rng.nextFloat() * 12.0f;
        }
        if (this.angle >= this.topstop) {
            this.wingspeed = -(this.rng.nextFloat() * (fastestSpeed - slowestSpeed) + slowestSpeed);
            this.bottomstop = -30.0f + this.rng.nextFloat() * 6.0f;
        }
        this.angle = this.correctAngle(this.angle, -30.0f, 90.0f);
    }

    public float correctAngle(float f, float bottom, float top) {
        float ret = f % (top - bottom);
        if (ret > top) {
            ret = top;
        }
        if (ret < bottom) {
            ret = bottom;
        }
        return ret;
    }

    public void setPlaceEffect(BlockPos pos, Direction direction, BlockState state, ItemStack stack) {
        this.effect = EFFECT.PLACE;
        this.placeBlock = new SerializableBlockPlace();
        this.placeBlock.loc = pos;
        this.placeBlock.state = state;
        this.placeBlock.stack = stack;
        this.origPos = pos.relative(direction);
        this.origPos1 = this.origPos.offset(1, 1, 1);
        this.setPos((double)this.origPos.getX() + 0.5, (double)this.origPos.getY() + 0.5, (double)this.origPos.getZ() + 0.5);
    }

    public void setBreakEffect(BlockPos pos, Direction direction, BlockState state) {
        this.effect = EFFECT.BREAK;
        this.breakBlock = new SerializableBlockBreak();
        this.breakBlock.loc = pos;
        this.breakBlock.state = state;
        this.origPos = pos.relative(direction);
        this.origPos1 = this.origPos.offset(1, 1, 1);
        this.setPos((double)this.origPos.getX() + 0.5, (double)this.origPos.getY() + 0.5, (double)this.origPos.getZ() + 0.5);
    }

    public void setHitEffect(Player player, ItemStack stack, ItemStack offstack) {
        this.effect = EFFECT.HIT;
        this.hit = new SerializableHit();
        this.hit.stack = stack;
        this.hit.offstack = offstack;
        this.hit.initialPosition = player.position();
        this.hit.effects = new ArrayList<MobEffectInstance>(player.getActiveEffects());
        this.hit.knockback = new Vec3((double)Mth.sin((float)(player.yRot * ((float)Math.PI / 180))), 0.0, (double)(-Mth.cos((float)(player.yRot * ((float)Math.PI / 180)))));
        this.hit.cooled = this.getCooledAttackStrength(player);
        this.hit.rotyaw = player.yRot;
        this.hit.rotpit = player.xRot;
        this.origPos = Utils.toBlockPos(player.getEyePosition(1.0f).add(player.getLookAngle().subtract(0.0, player.getLookAngle().y, 0.0)));
        this.origPos1 = this.origPos.offset(1, 1, 1);
        this.setPos((double)this.origPos.getX() + 0.5, (double)this.origPos.getY() + 0.5, (double)this.origPos.getZ() + 0.5);
    }

    public float getCooledAttackStrength(Player player) {
        return player.getAttackStrengthScale(0.5f);
    }

    public void attackTargetEntityWithCurrentItem(FakePlayer player, Entity pTarget) {
        player.setItemInHand(InteractionHand.MAIN_HAND, this.hit.stack);
        player.setItemInHand(InteractionHand.OFF_HAND, this.hit.offstack);
        Caliburn.updateAttr(this.hit.stack, (Player)player, EquipmentSlot.MAINHAND);
        Caliburn.updateAttr(this.hit.offstack, (Player)player, EquipmentSlot.OFFHAND);
        player.attackStrengthTicker = 1000;
        if (!CommonHooks.onPlayerAttackTarget((Player)player, (Entity)pTarget)) {
            return;
        }
        if (pTarget.isAttackable() && !pTarget.skipAttackInteraction((Entity)player)) {
            Projectile projectile;
            float f = player.isAutoSpinAttack() ? player.autoSpinAttackDmg : (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            ItemStack itemstack = this.hit.stack;
            DamageSource damagesource = player.damageSources().playerAttack((Player)player);
            float f1 = player.getEnchantedDamage(pTarget, f, damagesource) - f;
            float f2 = player.getAttackStrengthScale(0.5f);
            f *= 0.2f + f2 * f2 * 0.8f;
            f1 *= f2;
            if (pTarget.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && pTarget instanceof Projectile && (projectile = (Projectile)pTarget).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true)) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource());
                return;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag;
                boolean flag4;
                boolean bl = flag4 = f2 > 0.9f;
                if (player.isSprinting() && flag4) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, player.getSoundSource(), 1.0f, 1.0f);
                    flag = true;
                } else {
                    flag = false;
                }
                f += itemstack.getItem().getAttackDamageBonus(pTarget, f, damagesource);
                boolean flag1 = flag4 && player.fallDistance > 0.0f && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.hasEffect(MobEffects.BLINDNESS) && !player.isPassenger() && pTarget instanceof LivingEntity && !player.isSprinting();
                CriticalHitEvent critEvent = CommonHooks.fireCriticalHit((Player)player, (Entity)pTarget, (boolean)flag1, (float)(flag1 ? 1.5f : 1.0f));
                flag1 = critEvent.isCriticalHit();
                if (flag1) {
                    f *= critEvent.getDamageMultiplier();
                }
                float f3 = f + f1;
                boolean flag2 = false;
                double d0 = player.walkDist - player.walkDistO;
                if (flag4 && !flag1 && !flag && player.onGround() && d0 < (double)player.getSpeed()) {
                    ItemStack itemstack1 = player.getItemInHand(InteractionHand.MAIN_HAND);
                    flag2 = itemstack1.canPerformAction(ItemAbilities.SWORD_SWEEP);
                }
                float f6 = 0.0f;
                if (pTarget instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)pTarget;
                    f6 = livingentity.getHealth();
                }
                Vec3 vec3 = pTarget.getDeltaMovement();
                boolean flag3 = pTarget.hurt(damagesource, f3);
                if (flag3) {
                    float f4 = player.getKnockback(pTarget, damagesource) + (flag ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (pTarget instanceof LivingEntity) {
                            LivingEntity livingentity1 = (LivingEntity)pTarget;
                            livingentity1.knockback((double)(f4 * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        } else {
                            pTarget.push((double)(-Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))) * f4 * 0.5f), 0.1, (double)(Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * f4 * 0.5f));
                        }
                        player.setDeltaMovement(player.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        player.setSprinting(false);
                    }
                    if (flag2) {
                        float f7 = 1.0f + (float)player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * f;
                        for (LivingEntity livingentity2 : player.level().getEntitiesOfClass(LivingEntity.class, pTarget.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                            double entityReachSq = Mth.square((double)player.entityInteractionRange());
                            if (livingentity2 == player || livingentity2 == pTarget || player.isAlliedTo((Entity)livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)livingentity2).isMarker() || !(player.distanceToSqr((Entity)livingentity2) < entityReachSq)) continue;
                            float f5 = player.getEnchantedDamage((Entity)livingentity2, f7, damagesource) * f2;
                            livingentity2.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                            livingentity2.hurt(damagesource, f5);
                            Level level = player.level();
                            if (!(level instanceof ServerLevel)) continue;
                            ServerLevel serverlevel = (ServerLevel)level;
                            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)livingentity2, (DamageSource)damagesource);
                        }
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                        player.sweepAttack();
                    }
                    if (pTarget instanceof ServerPlayer && pTarget.hurtMarked) {
                        ((ServerPlayer)pTarget).connection.send((Packet)new ClientboundSetEntityMotionPacket(pTarget));
                        pTarget.hurtMarked = false;
                        pTarget.setDeltaMovement(vec3);
                    }
                    if (flag1) {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
                        player.crit(pTarget);
                    }
                    if (!flag1 && !flag2) {
                        if (flag4) {
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, player.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, player.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.magicCrit(pTarget);
                    }
                    player.setLastHurtMob(pTarget);
                    Entity entity = pTarget;
                    if (pTarget instanceof PartEntity) {
                        entity = ((PartEntity)pTarget).getParent();
                    }
                    boolean flag5 = false;
                    ItemStack copy = itemstack.copy();
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel1 = (ServerLevel)level;
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingentity3 = (LivingEntity)entity;
                            flag5 = itemstack.hurtEnemy(livingentity3, (Player)player);
                        }
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)pTarget, (DamageSource)damagesource);
                    }
                    if (!player.level().isClientSide && !itemstack.isEmpty() && entity instanceof LivingEntity) {
                        if (flag5) {
                            itemstack.postHurtEnemy((LivingEntity)entity, (Player)player);
                        }
                        if (itemstack.isEmpty()) {
                            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)(itemstack == player.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
                            if (itemstack == player.getMainHandItem()) {
                                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                            } else {
                                player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                            }
                        }
                    }
                    if (pTarget instanceof LivingEntity) {
                        float f8 = f6 - ((LivingEntity)pTarget).getHealth();
                        player.awardStat(Stats.DAMAGE_DEALT, Math.round(f8 * 10.0f));
                        if (player.level() instanceof ServerLevel && f8 > 2.0f) {
                            int i = (int)((double)f8 * 0.5);
                            ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, pTarget.getX(), pTarget.getY(0.5), pTarget.getZ(), i, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.causeFoodExhaustion(0.1f);
                } else {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource(), 1.0f, 1.0f);
                }
            }
            player.resetAttackStrengthTicker();
        }
    }

    public boolean triggerEffect(Entity e) {
        if (this.effect == EFFECT.PLACE) {
            if (this.placeBlock != null && this.placeBlock.loc != null && this.level() != null && this.getCasterUUID() != null) {
                if (!Utils.isBlockAir(this.level(), this.placeBlock.loc) || !EffectUtil.tryChangeBlockState(false, this.placeBlock.loc, this.placeBlock.state, this.level(), this.level().getPlayerByUUID(this.getCasterUUID()), this.getCasterUUID())) {
                    this.spawnAtLocation(this.placeBlock.stack);
                }
                this.startDying();
                return true;
            }
        } else if (this.effect == EFFECT.BREAK) {
            if (this.breakBlock != null && this.breakBlock.loc != null && this.level() != null && this.getCasterUUID() != null) {
                boolean z;
                if (this.level().getBlockState(this.breakBlock.loc).equals(this.breakBlock.state) && (z = EffectUtil.tryChangeBlockState(false, this.breakBlock.loc, Blocks.AIR.defaultBlockState(), this.level(), this.level().getPlayerByUUID(this.getCasterUUID()), this.getCasterUUID()))) {
                    if (this.level().getPlayerByUUID(this.getCasterUUID()) != null) {
                        MandatoryFun.completeFunReq(this.level().getPlayerByUUID(this.getCasterUUID()), MandatoryFun.FUN_REQS.BUTTERFLY_FUTURE_BLOCK_REMOVE);
                    }
                    Block.dropResources((BlockState)this.breakBlock.state, (Level)this.level(), (BlockPos)this.breakBlock.loc);
                }
                this.startDying();
                return true;
            }
        } else if (this.effect == EFFECT.HIT && e instanceof LivingEntity && this.hit.stack != null) {
            SafeFakePlayer fake = SafeFakePlayer.createFakePlayerIfNull((ServerLevel)this.level());
            fake.setPos(this.hit.initialPosition.x, this.hit.initialPosition.y, this.hit.initialPosition.z);
            fake.setPosRaw(this.hit.initialPosition.x, this.hit.initialPosition.y, this.hit.initialPosition.z);
            fake.yRot = this.hit.rotyaw;
            fake.xRot = this.hit.rotpit;
            try {
                if (this.hit.effects != null && this.hit.effects.size() > 0) {
                    for (MobEffectInstance ei : this.hit.effects) {
                        if (ei.getEffect() == ModEffects.FORESIGHT.get()) continue;
                        fake.addEffect(ei);
                    }
                }
                this.attackTargetEntityWithCurrentItem(fake, e);
            }
            catch (Exception ex) {
                Utils.err(ex.toString());
            }
            this.startDying();
        }
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    protected void checkInsideBlocks() {
    }

    public boolean isInvisible() {
        Player player = MahouTsukaiMod.proxy.getPlayer();
        if (player == null) {
            return false;
        }
        return this.isInvisibleTo(player);
    }

    public boolean isInvisibleTo(Player player) {
        return player.getUUID().equals(this.getCasterUUID());
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER, Optional.of(uuid));
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER)).orElse(UUID.randomUUID());
    }

    public boolean collide(Entity e) {
        if (!(this.level().isClientSide || this.getCasterUUID() != null && e.getUUID().equals(this.getCasterUUID()) || e instanceof ButterflyEntity || ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), e))) {
            return this.triggerEffect(e);
        }
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setSize(compound.getFloat(TAG_SIZE));
        this.setSeed(compound.getInt(TAG_RANDOM_SEED));
        this.setDying(compound.getBoolean(TAG_DYING));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
        if (this.placeBlock == null) {
            this.placeBlock = new SerializableBlockPlace();
        }
        if (compound.contains(TAG_PLACE_BLOCK)) {
            this.placeBlock.read(this.level(), compound.getCompound(TAG_PLACE_BLOCK));
        }
        if (this.breakBlock == null) {
            this.breakBlock = new SerializableBlockBreak();
        }
        if (compound.contains(TAG_BREAK_BLOCK)) {
            this.breakBlock.read(this.level(), compound.getCompound(TAG_BREAK_BLOCK));
        }
        if (this.hit == null) {
            this.hit = new SerializableHit();
        }
        if (compound.contains(TAG_HIT)) {
            this.hit.read(compound.getCompound(TAG_HIT), this.level());
        }
        if (compound.contains(TAG_EFFECT) && compound.getInt(TAG_EFFECT) < EFFECT.values().length) {
            this.effect = EFFECT.values()[compound.getInt(TAG_EFFECT)];
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_SIZE, this.getSize());
        compound.putInt(TAG_RANDOM_SEED, this.getSeed());
        compound.putBoolean(TAG_DYING, this.getDying());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
        if (this.placeBlock != null) {
            compound.put(TAG_PLACE_BLOCK, (Tag)this.placeBlock.write(this.level()));
        }
        if (this.breakBlock != null) {
            compound.put(TAG_BREAK_BLOCK, (Tag)this.breakBlock.write());
        }
        if (this.hit != null) {
            compound.put(TAG_HIT, (Tag)this.hit.write(this.level()));
        }
        compound.putInt(TAG_EFFECT, this.effect.ordinal());
    }

    public float getSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public void setSize(float f) {
        this.entityData.set(SIZE, (Object)Float.valueOf(f));
    }

    public int getSeed() {
        return (Integer)this.entityData.get(RANDOM_SEED);
    }

    public void setSeed(int f) {
        this.entityData.set(RANDOM_SEED, (Object)f);
    }

    public boolean getDying() {
        return (Boolean)this.entityData.get(DYING);
    }

    public void setDying(boolean f) {
        this.entityData.set(DYING, (Object)f);
    }

    public static enum EFFECT {
        HIT,
        SHOOT,
        PLACE,
        BREAK,
        NONE;

    }
}

