/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.joml.Vector3f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.fiction.FictionMahou;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.BookRender;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class WilliamEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_STACK = "MAHOUTSUKAI_STACK";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Vector3f> STARTING_POINT = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Float> COVER_OPENNESS = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> PAGE_OPENNESS = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> THEATER_RUNNING = SynchedEntityData.defineId(WilliamEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public BookRender last_br;
    public BookRender br = new BookRender();
    public long clientTicks = 0L;
    public float[] page_colors = null;
    public float[] cover_colors = null;
    public float[] text_colors = null;
    public float[] circle_colors = null;
    boolean nocaster = false;
    public float py = 0.0f;
    public float yy = 0.0f;
    boolean down = true;
    public float goToYaw = -1.0f;
    public Vec3 goToPlace = null;
    public int unreachable = 0;

    public WilliamEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public WilliamEntity(Level world) {
        super((EntityType)ModEntities.WILLIAM.get(), world);
        this.noCulling = true;
    }

    public WilliamEntity(Level world, Player caster, float size, ItemStack stack) {
        this(world);
        this.entityData.set(CASTER_UUID, Optional.of(caster.getUUID()));
        this.sizer(size);
        this.setStack(stack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(-45.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(STACK, (Object)ItemStack.EMPTY);
        builder.define(STARTING_POINT, (Object)new Vector3f());
        builder.define(COVER_OPENNESS, (Object)Float.valueOf(90.0f));
        builder.define(PAGE_OPENNESS, (Object)Float.valueOf(0.5f));
        builder.define(THEATER_RUNNING, (Object)true);
    }

    public static void williamRightClick(PlayerInteractEvent.EntityInteract event) {
        Entity e = event.getTarget();
        if (e instanceof WilliamEntity) {
            WilliamEntity w = (WilliamEntity)e;
            if (!e.level().isClientSide && event.getHand() == InteractionHand.MAIN_HAND) {
                Player p;
                Player player = event.getEntity();
                if (player instanceof Player && (p = player).isDiscrete() && p.getUUID().equals(w.getCasterUUID())) {
                    w.setTheaterRunning(!w.getTheaterRunning());
                    if (!w.getTheaterRunning()) {
                        PlayerHelp.sendHelpMessage(p, PlayerHelp.Message.THEATER_OFF);
                    } else {
                        PlayerHelp.sendHelpMessage(p, PlayerHelp.Message.THEATER_ON);
                    }
                } else {
                    Utils.schedule(w.level(), () -> {
                        if (w.getStack() != null && w.isAlive()) {
                            w.level().addFreshEntity((Entity)new ItemEntity(w.level(), w.getX(), w.getY(), w.getZ(), w.getStack()));
                            w.discard();
                        } else {
                            w.discard();
                        }
                    });
                }
            }
        }
    }

    public Player getCaster() {
        UUID casterUUID = this.getCasterUUID();
        if (casterUUID == null || casterUUID.equals(UUID.fromString("00000000-0000-0000-0000-000000000000")) || casterUUID.equals(FaeEssence.faeID)) {
            return null;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            return server.getServer().getPlayerList().getPlayer(casterUUID);
        }
        return this.level().getPlayerByUUID(casterUUID);
    }

    public void tick() {
        super.tick();
        this.py = this.yy;
        if (((Vector3f)this.entityData.get(STARTING_POINT)).equals((Object)new Vector3f())) {
            this.entityData.set(STARTING_POINT, (Object)this.position().toVector3f());
        }
        this.yRotO = this.yRot;
        if (this.yRotO < 0.0f) {
            this.yRotO += 360.0f;
        }
        if (this.py < 0.0f) {
            this.py += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.yRot = this.getRotationRoll();
        this.xRot = this.getRotationPitch();
        this.setRot(this.yRot, this.xRot);
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        int style = 0;
        int fame = 0;
        ItemStack stack = this.getStack();
        if (stack != null && !stack.isEmpty() && stack.has(DataComponents.FICTION_COMPONENT)) {
            FictionMahou mahou = Utils.getFictionMahou(stack);
            style = mahou.getStyle();
            fame = mahou.getFame();
        }
        this.placesToBe();
        this.peopleToSee(style, fame);
        this.thingsToDo();
        this.plethora(style, fame);
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide) {
            this.hover();
        } else {
            this.last_br = this.br.clone();
            this.br.animateTick(this.clientTicks);
            ++this.clientTicks;
        }
    }

    public void move(MoverType type, Vec3 v) {
        v = this.collide(v);
        Vec3 go = this.position().add(v);
        this.setPos(go);
    }

    public void hover() {
        Vec3 curr = this.getDeltaMovement();
        double factor = 0.05;
        double mult = 0.02;
        if (curr.y < -1.0 * mult && this.down) {
            this.down = false;
        } else if (curr.y > 1.0 * mult && !this.down) {
            this.down = true;
        }
        this.setDeltaMovement(this.getDeltaMovement().x, curr.y + factor * mult * (double)(this.down ? -1 : 1), this.getDeltaMovement().z);
    }

    public void placesToBe() {
        if (!this.level().isClientSide) {
            float roll = this.getRotationRoll();
            this.goToYaw = Utils.mod(this.goToYaw, 360);
            boolean spin = false;
            if (this.goToPlace != null) {
                boolean bl = spin = Math.abs(this.goToYaw - roll) > 11.0f;
                if (!spin && Math.abs(this.goToYaw - roll) > 1.0f) {
                    this.setRotationRoll(this.goToYaw);
                }
            }
            if (spin) {
                float spinspeed = 10.0f;
                boolean goUp = Utils.yawUp(roll, this.goToYaw);
                if (!goUp) {
                    spinspeed *= -1.0f;
                }
                float newroll = Utils.mod(roll + spinspeed, 360);
                this.setRotationRoll(newroll);
            } else {
                boolean just = false;
                if (this.random.nextFloat() < 0.005f && this.goToPlace == null) {
                    Vector3f start = (Vector3f)this.entityData.get(STARTING_POINT);
                    Vec3 startv = new Vec3(start);
                    Vec3 towards = startv.subtract(this.position());
                    towards = new Vec3(towards.x + this.random.nextDouble() * 0.01, 0.0, towards.z + this.random.nextDouble() * 0.01);
                    double min = towards.length() + 1.0;
                    towards = towards.normalize().yRot(EffectUtil.toRad(this.random.nextInt(-90, 90))).scale(Math.max(min, this.random.nextDouble() * 2.0 + 1.0));
                    this.goToYaw = EffectUtil.toDegrees((float)Math.atan2(towards.x, towards.z)) + 180.0f;
                    this.goToPlace = this.position().add(towards);
                    just = true;
                    this.unreachable = 0;
                }
                if (this.goToPlace != null && !just) {
                    float speed = 0.1f;
                    Vec3 direction = this.goToPlace.subtract(this.position());
                    direction = new Vec3(direction.x, 0.0, direction.z);
                    if (direction.length() < (double)(speed * 5.0f)) {
                        this.goToPlace = null;
                        this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
                    } else {
                        direction = direction.normalize().scale((double)speed);
                        this.setDeltaMovement(direction.x, this.getDeltaMovement().y, direction.z);
                    }
                    ++this.unreachable;
                    if (this.unreachable > 50) {
                        this.goToPlace = null;
                    }
                }
            }
        }
    }

    public void thingsToDo() {
        if (!this.level().isClientSide) {
            if (this.random.nextDouble() < 0.003 || (double)Math.abs(((Float)this.entityData.get(COVER_OPENNESS)).floatValue() - 90.0f) < 0.01) {
                this.entityData.set(COVER_OPENNESS, (Object)Float.valueOf(this.random.nextInt(10, 60)));
            }
            if (this.random.nextDouble() < 0.1) {
                this.entityData.set(PAGE_OPENNESS, (Object)Float.valueOf(this.random.nextFloat() * 0.4f + 0.3f));
            }
        } else {
            float open = ((Float)this.entityData.get(COVER_OPENNESS)).floatValue();
            this.br.startAnimation(BookRender.TRANSFORMABLE.open_angle, this.br.front_cover_open_angle, open, 2.0);
            if (!this.br.animations.containsKey((Object)BookRender.TRANSFORMABLE.open_percentage)) {
                this.br.startAnimation(BookRender.TRANSFORMABLE.open_percentage, this.br.percentage_page_open, ((Float)this.entityData.get(PAGE_OPENNESS)).floatValue(), 0.05f);
            }
        }
    }

    public void plethora(int style, int fame) {
        block6: {
            List players;
            int remainingManaToGive;
            int range;
            block5: {
                range = MTConfig.WILLIAM_NEARBY_MANA_RANGE;
                remainingManaToGive = (int)((double)style * Math.abs((double)Math.max(0, fame) * MTConfig.WILLIAM_NEARBY_MANA_FACTOR));
                if (this.level().getGameTime() % (long)MTConfig.WILLIAM_PLETHORA_FREQUENCY != 0L) {
                    return;
                }
                if (remainingManaToGive <= 0) break block5;
                Set<BlockEntity> bes = PlayerManaManager.nearbyBatteries(Utils.toBlockPos(this.position()), this.level(), range, false);
                ArrayList<BlockEntity> be_list = new ArrayList<BlockEntity>(bes);
                Collections.shuffle(be_list);
                if (be_list.isEmpty()) break block6;
                for (BlockEntity be : be_list) {
                    ManaCircuitTileEntity mte;
                    if (!(be instanceof ManaCircuitTileEntity) || !(mte = (ManaCircuitTileEntity)be).getOwnerUUID().equals(this.getCasterUUID()) || remainingManaToGive <= 0 || mte.getMana() >= mte.getMaxMana()) continue;
                    int space = mte.getMaxMana() - mte.getMana();
                    if (remainingManaToGive > space) {
                        mte.setMana(mte.getMaxMana());
                        remainingManaToGive -= space;
                        continue;
                    }
                    mte.setMana(Math.min(mte.getMaxMana(), mte.getMana() + remainingManaToGive));
                    remainingManaToGive = 0;
                }
                break block6;
            }
            if (remainingManaToGive < 0 && !(players = this.level().getEntities((Entity)this, new AABB(this.position().add((double)(-range), (double)(-range), (double)(-range)), this.position().add((double)range, (double)range, (double)range)), entity -> entity instanceof Player)).isEmpty()) {
                remainingManaToGive /= players.size();
                for (Entity e : players) {
                    IMahou mahou;
                    int mana;
                    ServerPlayer p;
                    if (!(e instanceof ServerPlayer) || EffectUtil.hasBuff((LivingEntity)(p = (ServerPlayer)e), ModEffects.MANA_TAKEN_COOLDOWN) || (mana = (mahou = Utils.getPlayerMahou((Player)p)).getStoredMana()) <= 0) continue;
                    mahou.setStoredMana(Math.max(mana + remainingManaToGive, 0));
                    EffectUtil.buff((LivingEntity)p, ModEffects.MANA_TAKEN_COOLDOWN, false, 100, false);
                    PlayerManaManager.updateClientMahou(p, mahou);
                }
            }
        }
    }

    public void peopleToSee(int style, int fame) {
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            if (this.getLife() % 40 == 0 && this.getTheaterRunning()) {
                float range = MTConfig.WILLIAM_THEATER_RANGE;
                if (this.nocaster || WilliamEntity.operate(this.level(), this.getCasterUUID(), this.blockPosition())) {
                    AABB aabb = new AABB(this.getX() - (double)range, this.getY() - (double)range, this.getZ() - (double)range, this.getX() + (double)range, this.getY() + (double)range, this.getZ() + (double)range);
                    List lst = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
                    Player player = this.getCaster();
                    boolean includeCaster = lst.contains(player);
                    if (player != null) {
                        lst.remove(player);
                        lst.addFirst(player);
                    }
                    if (lst.size() > 1) {
                        RandomSource random = player != null ? player.getRandom() : this.getRandom();
                        ArrayList<Integer> ints = new ArrayList<Integer>();
                        for (int m = 0; m < lst.size(); ++m) {
                            ints.add(random.nextInt(lst.size()));
                        }
                        for (int n = 0; n < lst.size(); ++n) {
                            LivingEntity living = (LivingEntity)lst.get(n);
                            if (!includeCaster && living == player) continue;
                            if (style > 0) {
                                ILivingMahou mahou = Utils.getLivingMahou(living);
                                Entity e = this.level().getEntity(mahou.getActing());
                                if (!(e instanceof LivingEntity) || !e.isAlive()) {
                                    mahou.setActing(((LivingEntity)lst.get((Integer)ints.get(n))).getId());
                                }
                                EffectUtil.buff(living, ModEffects.ACTING, false, 200, true);
                                continue;
                            }
                            if (style >= 0) continue;
                            EffectUtil.buff(living, ModEffects.ABYSS, false, 200, true);
                        }
                    }
                }
            }
        }
    }

    public static boolean operate(Level world, UUID casterUUID, BlockPos pos) {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public void playerTouch(Player entityIn) {
    }

    protected void checkInsideBlocks() {
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.getFloat(TAG_CIRCLE_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
        if (compound.contains(TAG_STACK)) {
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)compound.get(TAG_STACK)).orElse(ModItems.rhongomyniad == null ? ItemStack.EMPTY : new ItemStack((ItemLike)ModItems.rhongomyniad));
            stack.setCount(1);
            this.setStack(stack);
        }
        this.nocaster = compound.getBoolean("NO_CASTER");
        if (compound.contains("THEATER_RUNNING")) {
            this.setTheaterRunning(compound.getBoolean("THEATER_RUNNING"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.putFloat(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
        if (this.getStack() != null) {
            compound.put(TAG_STACK, this.getStack().save((HolderLookup.Provider)this.level().registryAccess()));
        }
        compound.putBoolean("NO_CASTER", this.nocaster);
        compound.putBoolean("THEATER_RUNNING", this.getTheaterRunning());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public AABB getBoundingBox() {
        Vec3 v = this.position();
        float height = 0.5f;
        float width = 0.75f;
        return new AABB(v.x - (double)width, v.y - (double)height, v.z - (double)width, v.x + (double)width, v.y + (double)height, v.z + (double)width);
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public ItemStack getStack() {
        return (ItemStack)this.entityData.get(STACK);
    }

    public void setStack(ItemStack s) {
        this.entityData.set(STACK, (Object)s);
    }

    public void setTheaterRunning(boolean b) {
        this.entityData.set(THEATER_RUNNING, (Object)b);
    }

    public boolean getTheaterRunning() {
        return (Boolean)this.entityData.get(THEATER_RUNNING);
    }
}

