/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.clarent.Clarent;
import stepsword.mahoutsukai.mana.PlayerManaManager;

public class WeaponProjectileEntity
extends Arrow {
    public static final String entityName = "weapon_projectile_entity";
    public static Field a1 = null;
    public static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public int wpe_life = 0;
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(WeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public WeaponProjectileEntity(Level worldIn) {
        super((EntityType)ModEntities.WEAPON_PROJECTILE.get(), worldIn);
        this.noCulling = true;
        this.setStack(new ItemStack((ItemLike)Items.IRON_SWORD));
    }

    public WeaponProjectileEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn);
        this.setPos(x, y, z);
        this.setStack(stack);
        this.noCulling = true;
    }

    public WeaponProjectileEntity(Level worldIn, LivingEntity shooter, ItemStack stack) {
        this(worldIn, shooter.getX(), shooter.getY() + (double)shooter.getEyeHeight() - (double)0.1f, shooter.getZ(), stack);
        this.setOwner((Entity)shooter);
        this.pickup = AbstractArrow.Pickup.ALLOWED;
        this.noCulling = true;
        this.wpe_life = 0;
    }

    public boolean shouldBeSaved() {
        return !RealityMarbleSpellEffect.inMarble(this.level());
    }

    public WeaponProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEM, (Object)new ItemStack((ItemLike)Items.IRON_SWORD));
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        if (this.getStack() != null) {
            nbt.put("stackNBT", this.getStack().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)nbt));
        }
        nbt.putInt("wpe_life", this.wpe_life);
        super.addAdditionalSaveData(nbt);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("stackNBT")) {
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)((CompoundTag)nbt.get("stackNBT"))).orElse(Items.IRON_SWORD.getDefaultInstance());
            stack.setCount(1);
            this.setStack(stack);
        }
        this.wpe_life = nbt.getInt("wpe_life");
        super.readAdditionalSaveData(nbt);
    }

    protected ItemStack getPickupItem() {
        return this.getStack();
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.level() instanceof ServerLevel && !GateWeaponProjectileEntity.shouldAvoid(this.getOwner(), entity)) {
            SafeFakePlayer fake_player = SafeFakePlayer.createFakePlayerIfNull((ServerLevel)this.level());
            ItemStack stack = this.getPickupItem();
            fake_player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            Caliburn.updateAttr(stack, (Player)fake_player, EquipmentSlot.MAINHAND);
            fake_player.getAttributes().getInstance(Attributes.ATTACK_DAMAGE).addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"weapon_shooter_config"), MTConfig.WEAPON_SHOOTER_DAMAGE_MULTIPLIER - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            if (!(entity instanceof AbstractArrow)) {
                Entity entity2 = this.getOwner();
                if (entity2 instanceof Player) {
                    Player p = (Player)entity2;
                    MandatoryFun.completeFunReq(p, MandatoryFun.FUN_REQS.SHOOT_A_SWORD);
                }
                if (this.getStack().getItem() instanceof Clarent && this.getOwner() instanceof Player) {
                    int mana = ClarentEffect.getManaCostClarent(this.getStack(), (Player)this.getOwner());
                    PlayerManaManager.donateManaToFakePlayer(fake_player, (Player)this.getOwner(), mana);
                }
                fake_player.attackStrengthTicker = 1000;
                fake_player.attack(entity);
                if (entity instanceof LivingEntity) {
                    this.doPostHurtEffects((LivingEntity)entity);
                }
                Entity shooter = null;
                if (this.getOwner() != null && entity != (shooter = this.getOwner()) && entity instanceof Player && shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
        }
    }

    public void tick() {
        if (this.life > 5) {
            this.life = 4;
        }
        ++this.wpe_life;
        if (this.wpe_life > 3600) {
            this.discard();
        }
        super.tick();
    }

    public void playerTouch(Player player) {
        if (!this.level().isClientSide && this.inGround) {
            boolean flag = true;
            ItemStack stack = this.getPickupItem().copy();
            stack.setCount(1);
            stack.hurtAndBreak(2, (LivingEntity)player, EquipmentSlot.MAINHAND);
            if (!player.getInventory().add(stack)) {
                flag = false;
            }
            if (flag) {
                player.take((Entity)this, 1);
                this.discard();
            }
        }
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        this.setDeltaMovement(this.getDeltaMovement().add(shooter.getDeltaMovement().x, shooter.onGround() ? 0.0 : shooter.getDeltaMovement().y, shooter.getDeltaMovement().z));
    }

    public ItemStack getStack() {
        return (ItemStack)this.getEntityData().get(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.getEntityData().set(ITEM, (Object)stack);
    }

    public AABB getBoundingBoxForCulling() {
        return new AABB(this.getX() - 1.0, this.getY() - 1.0, this.getZ() - 1.0, this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }
}

