/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.networking.DonePossessingPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class PossessEntityClientEffect {
    public static Entity possessionHold = null;

    public static void possessEntityInputUpdate(Input mi, Player player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou(player)) != null && mahou.isPossessing() && (mi.jumping || mi.shiftKeyDown || mi.left || mi.up || mi.down || mi.right) && PossessEntityClientEffect.isActuallyPossessing(player)) {
            mi.jumping = false;
            mi.shiftKeyDown = false;
            mi.left = false;
            mi.up = false;
            mi.down = false;
            mi.right = false;
        }
    }

    public static boolean possessEntityRenderHand() {
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.getInstance().player);
        return mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing((Player)Minecraft.getInstance().player);
    }

    public static void possessEntityMouseInput() {
        KeyMapping k;
        LocalPlayer player = Minecraft.getInstance().player;
        IMahou mahou = Utils.getPlayerMahou((Player)Minecraft.getInstance().player);
        if (mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing((Player)player) && (k = Minecraft.getInstance().options.keyAttack).consumeClick()) {
            k.release();
            PossessEntityClientEffect.possessEntityDisallowedAction((Player)Minecraft.getInstance().player);
        }
    }

    public static boolean isActuallyPossessing(Player player) {
        if (!(Minecraft.getInstance().getCameraEntity() instanceof MentalDisplacementEntity)) {
            return !(Minecraft.getInstance().getCameraEntity() instanceof Player) || !Minecraft.getInstance().getCameraEntity().getUUID().equals(player.getUUID());
        }
        return false;
    }

    public static boolean possessEntityDisallowedAction(Player player) {
        boolean ret = false;
        if (player != null) {
            IMahou mahou = Utils.getPlayerMahou(player);
            if (player.level().isClientSide) {
                if (mahou != null && mahou.isPossessing()) {
                    Entity entity = Minecraft.getInstance().getCameraEntity();
                    Minecraft.getInstance().setCameraEntity((Entity)player);
                    if (entity != null) {
                        ChunkPos pos = new ChunkPos(entity.blockPosition());
                        PacketHandler.sendToServer(new DonePossessingPacket());
                        ret = true;
                    }
                }
            } else if (mahou != null && mahou.isPossessing()) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean possessEntityDisallowedAction(PlayerInteractEvent event) {
        boolean ret = false;
        Player player = event.getEntity();
        if (player != null) {
            IMahou mahou = Utils.getPlayerMahou(player);
            if (event.getLevel().isClientSide && mahou != null && mahou.isPossessing()) {
                Entity entity = Minecraft.getInstance().getCameraEntity();
                Minecraft.getInstance().setCameraEntity((Entity)player);
                if (entity != null) {
                    ChunkPos pos = new ChunkPos(entity.blockPosition());
                    ret = true;
                    PacketHandler.sendToServer(new DonePossessingPacket());
                }
            }
        } else {
            IMahou mahou = Utils.getPlayerMahou(player);
            if (mahou != null && mahou.isPossessing()) {
                ret = true;
            }
        }
        return ret;
    }

    public static void possessionRenderWorldLast(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        IMahou mahou = Utils.getPlayerMahou((Player)player);
        if (mahou != null && mahou.isPossessing() && PossessEntityClientEffect.isActuallyPossessing((Player)player)) {
            Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
            float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
            Vec3 Vec32 = renderInfo.getPosition();
            double xx = Vec32.x();
            double yy = Vec32.y();
            double zz = Vec32.z();
            double d0 = Mth.lerp((double)partialTicks, (double)player.xOld, (double)player.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)player.yOld, (double)player.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)player.zOld, (double)player.getZ());
            float f = Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.yRot);
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)player, d0 - xx, d1 - yy, d2 - zz, f, partialTicks, event.getPoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 240);
        }
    }
}

