/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import stepsword.mahoutsukai.client.AbyssClientEffect;
import stepsword.mahoutsukai.client.ActingClientEffect;
import stepsword.mahoutsukai.client.BorrowedAuthorityClientEffect;
import stepsword.mahoutsukai.client.ButterflyClientEffect;
import stepsword.mahoutsukai.client.ClarentClientEffect;
import stepsword.mahoutsukai.client.ConfusionClientEffect;
import stepsword.mahoutsukai.client.ManaClientEvents;
import stepsword.mahoutsukai.client.MentalDisplacementClientEffect;
import stepsword.mahoutsukai.client.MorganClientEffect;
import stepsword.mahoutsukai.client.MysticCodeClientEffect;
import stepsword.mahoutsukai.client.NobuClientEffect;
import stepsword.mahoutsukai.client.PossessEntityClientEffect;
import stepsword.mahoutsukai.client.RipperClientEffect;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ProximityProjectionSpellEffect;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.potion.BoundPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.ProjectorRenderer;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.enchant.RenderProjectorEnchant;
import stepsword.mahoutsukai.render.gui.MahouGui;
import stepsword.mahoutsukai.render.gui.RenderPowerConsolidationInnateCap;
import stepsword.mahoutsukai.render.gui.RenderRuleBreakerModulus;
import stepsword.mahoutsukai.render.gui.RenderStrengthening;
import stepsword.mahoutsukai.render.gui.RenderWilliamStats;
import stepsword.mahoutsukai.render.overlay.RenderBlackBurning;
import stepsword.mahoutsukai.render.overlay.RenderBoundOverlay;
import stepsword.mahoutsukai.render.overlay.RenderClairvoyance;
import stepsword.mahoutsukai.render.overlay.RenderFogProjectors;
import stepsword.mahoutsukai.render.overlay.RenderInsightOverlay;
import stepsword.mahoutsukai.render.overlay.RenderInterestingBlock;
import stepsword.mahoutsukai.render.overlay.RenderLeyLines;
import stepsword.mahoutsukai.render.overlay.RenderPowerConsolidation;
import stepsword.mahoutsukai.render.overlay.RenderRevertedOverlay;
import stepsword.mahoutsukai.render.overlay.RenderSelectedEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class ClientHandler {
    public static boolean tint = false;
    public static long changed = 0L;
    public static long clientTickCounter = 0L;

    @SubscribeEvent
    public void clientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        ProjectorRenderer.cacheClear();
    }

    @SubscribeEvent
    public void renderOverlay(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.EFFECTS)) {
            RenderInsightOverlay.insightOverlay(event.getGuiGraphics());
            RenderBoundOverlay.boundOverlay(event.getGuiGraphics());
            RenderRevertedOverlay.revertedOverlay(event.getGuiGraphics());
            MahouGui.mahoujinOverlay(event.getGuiGraphics());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void renderWorldLast(RenderLevelStageEvent event) {
        Entity entity;
        Entity re = Minecraft.getInstance().getCameraEntity();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY && (entity = Minecraft.getInstance().cameraEntity) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (EffectUtil.hasBuff(living, ModEffects.ABYSS)) {
                if (!tint) {
                    Minecraft.getInstance().levelRenderer.allChanged();
                }
                tint = true;
            } else {
                if (tint) {
                    Minecraft.getInstance().levelRenderer.allChanged();
                }
                tint = false;
            }
        }
        if (re != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            RenderUtils.entityRenders(re, event.getPoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
        }
        if (re != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            RenderLeyLines.leyRender(re, event.getPoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderUtils.particleRenders(re, event.getPoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderClairvoyance.renderPrediction(event.getPoseStack(), re, event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderInterestingBlock.interestingBlockOverlay(event.getPoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(false));
            if (re instanceof MentalDisplacementEntity) {
                MentalDisplacementClientEffect.mentalDisplacementRenderWorldLast(event);
            }
            PossessEntityClientEffect.possessionRenderWorldLast(event);
            RenderSelectedEntity.renderSelectedEntity(event);
            NobuClientEffect.displayAutoTargetsCrosshairs(event);
        }
    }

    @SubscribeEvent
    public void renderLivingPre(RenderLivingEvent.Pre event) {
        RenderBlackBurning.renderEntityFire(event.getEntity(), event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick(), event.getRenderer());
        RenderProjectorEnchant.renderProjectorEnchantment(event);
        ActingClientEffect.renderEntity(event);
    }

    @SubscribeEvent
    public void renderLivingPre(RenderHandEvent event) {
        RenderBlackBurning.renderOverlayFire(event.getPoseStack(), event.getPartialTick());
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityRenderHand());
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementRenderHand());
        if (!event.isCanceled()) {
            MysticCodeClientEffect.renderHand(event);
        }
    }

    @SubscribeEvent
    public void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ProximityProjectionSpellEffect.proximityProjectionLeftClickEmpty(event.getEntity());
        PowerConsolidationSpellEffect.caliburnLeftClickSpace(event);
        ButterflyClientEffect.butterflyHit((PlayerInteractEvent)event);
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void itemTooltip(ItemTooltipEvent event) {
        RenderStrengthening.strengthenTooltip(event.getItemStack(), event.getToolTip());
        RenderWilliamStats.fameStyleToolTip(event.getItemStack(), event.getToolTip());
        RenderPowerConsolidationInnateCap.innateCapTooltip(event.getItemStack(), event.getToolTip());
        RenderRuleBreakerModulus.modulusTooltip(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Post event) {
        ManaClientEvents.keyPress();
        RenderSelectedEntity.selectedEntity((Entity)Minecraft.getInstance().player);
        NobuClientEffect.nobuAutoTargetMode((Player)Minecraft.getInstance().player);
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().level != null) {
            AbyssClientEffect.setRenderer((Level)Minecraft.getInstance().level);
        }
        ++clientTickCounter;
        clientTickCounter %= 50000L;
        RenderInsightOverlay.insightCounters();
    }

    @SubscribeEvent
    public void keyBindPressed(InputEvent.MouseButton.Pre event) {
        PossessEntityClientEffect.possessEntityMouseInput();
        MentalDisplacementClientEffect.mentalDisplacementMouseInput();
        BorrowedAuthorityClientEffect.borrowedAuthorityLeftClickingJump((InputEvent.MouseButton)event);
        NobuClientEffect.nobuClick(event);
    }

    @SubscribeEvent
    public void keyBindPressed(InputEvent.MouseButton.Post event) {
        BorrowedAuthorityClientEffect.borrowedAuthorityLeftClickingJump((InputEvent.MouseButton)event);
    }

    @SubscribeEvent
    public void clickInputPressed(InputEvent.InteractionKeyMappingTriggered event) {
        ServerHandler.cancelEvent((Event)event, RipperClientEffect.ripperPlayerLeftClick(event));
    }

    @SubscribeEvent
    public void inputUpdate(MovementInputUpdateEvent event) {
        PossessEntityClientEffect.possessEntityInputUpdate(event.getInput(), event.getEntity());
        MentalDisplacementClientEffect.mentalDisplacementInputUpdate(event.getInput(), event.getEntity());
        BoundPotion.boundMovement(event.getEntity(), event.getInput());
        ConfusionClientEffect.confusionInputUpdate(event.getEntity(), event.getInput());
        BorrowedAuthorityClientEffect.borrowedAuthorityJumpEffect(event.getEntity(), event.getInput());
    }

    @SubscribeEvent
    public void rightClickEventBlockP(PlayerInteractEvent.RightClickBlock event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void rightClickEventItemP(PlayerInteractEvent.RightClickItem event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void rightClickEventEmptyP(PlayerInteractEvent.RightClickEmpty event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void leftClickEventBlockP(PlayerInteractEvent.LeftClickBlock event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction(event.getEntity()));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinLevelEvent event) {
        MentalDisplacementClientEffect.mentalDisplacementEntityJoin(event.getEntity());
    }

    @SubscribeEvent
    public void textOverlay(RenderGuiLayerEvent.Post event) {
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void fogColorEvent(ViewportEvent.ComputeFogColor event) {
        boolean lake = RenderPowerConsolidation.powerConsolidationFogColor(event);
        ServerHandler.cancelEvent((Event)event, lake);
        if (!lake) {
            ServerHandler.cancelEvent((Event)event, RenderFogProjectors.fogProjectorColor(event));
        }
    }

    @SubscribeEvent
    public void blockOverlay(RenderBlockScreenEffectEvent event) {
        ServerHandler.cancelEvent((Event)event, RenderPowerConsolidation.powerConsolidationBlockOverlay(event));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void renderFog(ViewportEvent.RenderFog event) {
        boolean lake = RenderPowerConsolidation.powerConsolidationRenderFog(event);
        ServerHandler.cancelEvent((Event)event, lake);
        if (!lake) {
            ServerHandler.cancelEvent((Event)event, RenderFogProjectors.fogProjectorRenderFog(event));
        }
        RenderPowerConsolidation.powerConsolidationFogDensity(event);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        ClarentClientEffect.clarentRenderPlayer(event);
        ServerHandler.cancelEvent((Event)event, RipperClientEffect.ripperRenderPlayer(event.getEntity()));
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        ClarentClientEffect.clarentRenderPlayer(event);
    }

    @SubscribeEvent
    public void livingUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            ActingClientEffect.entityMap(e);
            MorganClientEffect.morganParticlesLivingUpdate(e);
            BorrowedAuthorityClientEffect.borrowedAuthorityParticlesLivingUpdate(e);
            BorrowedAuthorityClientEffect.borrowedAuthorityJumpingPunch(e);
        }
    }
}

