/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.network.packets;

import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.body.WingWildStalkerItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class WingStartFlyPacket
implements CustomPacketPayload {
    private final boolean toggled;
    public static final CustomPacketPayload.Type<WingStartFlyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_ars_nouveau", (String)"flying"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WingStartFlyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, WingStartFlyPacket::isToggled, WingStartFlyPacket::new);

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            List stacks = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value()));
            ItemStack stackFirst = (ItemStack)stacks.getFirst();
            Item patt0$temp = stackFirst.getItem();
            if (!(patt0$temp instanceof WingWildStalkerItem)) {
                return;
            }
            WingWildStalkerItem relic = (WingWildStalkerItem)patt0$temp;
            if (this.toggled) {
                int charge = 0;
                if (stacks.size() > 1) {
                    for (ItemStack stack : stacks) {
                        if (stackFirst == stack) continue;
                        WingWildStalkerItem item = (WingWildStalkerItem)stack.getItem();
                        charge += item.getActualStatValue(stack, "charges");
                    }
                }
                relic.setCharge(stackFirst, relic.getActualStatValue(stackFirst, "charges") + charge);
            } else {
                relic.consumeCharge(stackFirst, 1);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WingStartFlyPacket)) {
            return false;
        }
        WingStartFlyPacket other = (WingStartFlyPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isToggled() == other.isToggled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WingStartFlyPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isToggled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "WingStartFlyPacket(toggled=" + this.isToggled() + ")";
    }

    public WingStartFlyPacket(boolean toggled) {
        this.toggled = toggled;
    }
}

