/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LockButton
extends AbstractButtonWidget {
    private boolean locked;
    private boolean active = true;

    public LockButton(int x, int y) {
        super(x, y, 20, 20, null);
    }

    public void onPress() {
        super.onPress();
        this.locked = !this.locked;
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"gui.narrate.button", (Object[])new Object[]{TextComponents.translation((String)"narrator.button.difficulty_lock").get()}).string(". ").translation(this.isLocked() ? "narrator.button.difficulty_lock.locked" : "narrator.button.difficulty_lock.unlocked").get();
    }

    public void render(WidgetRenderContext context, int x, int y) {
        Icon icon = !this.active ? (this.locked ? Icon.LOCKED_DISABLED : Icon.UNLOCKED_DISABLED) : (this.isFocused() ? (this.locked ? Icon.LOCKED_HOVER : Icon.UNLOCKED_HOVER) : (this.locked ? Icon.LOCKED : Icon.UNLOCKED));
        ScreenUtils.bindTexture((ResourceLocation)icon.location);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean lockedIn) {
        this.locked = lockedIn;
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        tooltips.accept((Component)TextComponents.translation((String)("gui.tesseract.channel." + (this.locked ? "private" : "public"))).get());
    }

    static enum Icon {
        LOCKED(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/locked_button.png")),
        LOCKED_HOVER(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/locked_button_highlighted.png")),
        LOCKED_DISABLED(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/locked_button_disabled.png")),
        UNLOCKED(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/unlocked_button.png")),
        UNLOCKED_HOVER(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/unlocked_button_highlighted.png")),
        UNLOCKED_DISABLED(ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/unlocked_button_disabled.png"));

        private final ResourceLocation location;

        private Icon(ResourceLocation location) {
            this.location = location;
        }

        public ResourceLocation location() {
            return this.location;
        }
    }
}

