/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.lootbundles.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import cy.jdkdigital.lootbundles.LootBundleConfig;
import cy.jdkdigital.lootbundles.init.ModLootModifiers;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.neoforge.common.util.FakePlayer;

public class LootItemKilledByRealPlayer
implements LootItemCondition {
    static final LootItemKilledByRealPlayer INSTANCE = new LootItemKilledByRealPlayer();
    public static final MapCodec<LootItemKilledByRealPlayer> CODEC = MapCodec.unit((Object)INSTANCE);

    private LootItemKilledByRealPlayer() {
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)ModLootModifiers.KILLED_BY_REAL_PLAYER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.LAST_DAMAGE_PLAYER);
    }

    public boolean test(LootContext context) {
        return context.hasParam(LootContextParams.LAST_DAMAGE_PLAYER) && ((Boolean)LootBundleConfig.COMMON.allowFakePlayerDrops.get() != false || !(context.getParam(LootContextParams.LAST_DAMAGE_PLAYER) instanceof FakePlayer));
    }

    public static LootItemCondition.Builder killedByPlayer() {
        return () -> INSTANCE;
    }
}

