/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.lootbundles.loot;

import com.google.common.base.Supplier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.lootbundles.init.ModItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LootBundleModifier
extends LootModifier {
    public static final Supplier<MapCodec<LootBundleModifier>> CODEC = () -> RecordCodecBuilder.mapCodec(inst -> inst.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)Codec.FLOAT.fieldOf("probability").orElse((Object)Float.valueOf(0.0f)).forGetter(configuration -> Float.valueOf(configuration.probability)), (App)Codec.INT.fieldOf("maxCount").orElse((Object)1).forGetter(configuration -> configuration.maxCount)).apply((Applicative)inst, LootBundleModifier::new));
    private final float probability;
    private final Integer maxCount;

    protected LootBundleModifier(LootItemCondition[] conditionsIn, float probability, int maxCount) {
        super(conditionsIn);
        this.probability = probability;
        this.maxCount = maxCount;
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.getRandom().nextFloat() < this.probability) {
            generatedLoot.add((Object)new ItemStack((ItemLike)ModItems.LOOT_BUNDLE.get(), context.getRandom().nextInt(1, this.maxCount + 1)));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)CODEC.get();
    }
}

