/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.lootbundles.item;

import cy.jdkdigital.lootbundles.LootBundleConfig;
import cy.jdkdigital.lootbundles.LootBundles;
import cy.jdkdigital.lootbundles.init.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LootBundle
extends Item {
    private static final List<Item> possibleItems = new ArrayList<Item>();

    public LootBundle(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide()) {
            ItemStack itemStack = player.getItemInHand(hand);
            int usedBundles = 1;
            if (player.isShiftKeyDown()) {
                usedBundles = itemStack.getCount();
            }
            boolean hasUsedBundle = false;
            for (int k = 0; k < usedBundles; ++k) {
                int max;
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                int min = (Integer)LootBundleConfig.COMMON.minLootAmount.get();
                int count = min <= (max = ((Integer)LootBundleConfig.COMMON.maxLootAmount.get()).intValue()) ? level.random.nextInt(min, max + 1) : level.random.nextInt(max + 1);
                int i = 0;
                for (int u = 0; i < count && u < 200; ++u) {
                    ItemStack randomStack = LootBundle.getRandomItem(level.random);
                    if (randomStack.isEmpty()) continue;
                    items.add(randomStack);
                    ++i;
                }
                if (!LootBundle.dropContents(items, player)) continue;
                itemStack.shrink(1);
                this.playDropContentsSound((Entity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                hasUsedBundle = true;
            }
            if (hasUsedBundle) {
                return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
            }
        }
        return super.use(level, player, hand);
    }

    private static ItemStack getRandomItem(RandomSource rand) {
        if (possibleItems.isEmpty()) {
            if (((Boolean)LootBundleConfig.COMMON.whitelist.get()).booleanValue()) {
                BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.WHITELIST).forEach(itemHolder -> LootBundle.addIfAllowed(possibleItems, (Holder<Item>)itemHolder));
            } else {
                BuiltInRegistries.ITEM.holders().forEach(itemHolder -> LootBundle.addIfAllowed(possibleItems, (Holder<Item>)itemHolder));
            }
        }
        if (possibleItems.size() > 0) {
            Item item = possibleItems.get(rand.nextInt(possibleItems.size()));
            ItemStack stack = new ItemStack((ItemLike)item);
            stack.setCount(Math.min(item.getMaxStackSize(stack), rand.nextInt(1, (Integer)LootBundleConfig.COMMON.maxStackSize.get() + 1)));
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static void addIfAllowed(List<Item> possibleItems, Holder<Item> itemHolder) {
        Item item = (Item)itemHolder.value();
        if (LootBundle.isItemAllowed(item)) {
            LootBundles.LootWeightData weightData = (LootBundles.LootWeightData)itemHolder.getData(LootBundles.LOOT_WEIGHT_DATA);
            int weight = weightData != null ? weightData.weight() : 1;
            IntStream.range(0, weight).forEach(i -> possibleItems.add(item));
        }
    }

    private static boolean dropContents(List<ItemStack> stacks, Player player) {
        if (player instanceof ServerPlayer) {
            for (ItemStack stack : stacks) {
                if (((Boolean)LootBundleConfig.COMMON.inventoryInsert.get()).booleanValue() && player.getInventory().getFreeSlot() > 0) {
                    player.addItem(stack);
                    continue;
                }
                player.drop(stack, true);
            }
        }
        return true;
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static boolean isItemAllowed(Item item) {
        if (!item.builtInRegistryHolder().is(ModTags.BLACKLIST)) {
            if (!item.builtInRegistryHolder().is(ModTags.WHITELIST) && !((List)LootBundleConfig.COMMON.disallowedItemNames.get()).isEmpty()) {
                for (String s : (List)LootBundleConfig.COMMON.disallowedItemNames.get()) {
                    if (!BuiltInRegistries.ITEM.getKey((Object)item).toString().contains(s)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

