/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import ovh.corail.tombstone.mixin.accessor.ShapelessRecipeAccessor;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;

public class ShapelessSerializer<T extends DisableableShapelessRecipe>
implements RecipeSerializer<T> {
    private final DisableableShapelessRecipe.Factory<T> factory;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public ShapelessSerializer(DisableableShapelessRecipe.Factory<T> factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> ((ShapelessRecipeAccessor)((Object)recipe)).getResult()), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] ingredientArray = (Ingredient[])ingredients.stream().filter(i -> !i.isEmpty()).toArray(Ingredient[]::new);
            if (ingredientArray.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredientArray.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredientArray));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)c, factory::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    private T fromNetwork(RegistryFriendlyByteBuf buffer) {
        String group = buffer.readUtf();
        CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
        int ingredientCount = buffer.readVarInt();
        NonNullList ingredients = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
        ingredients.replaceAll(i -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        return this.factory.create(group, category, result, (NonNullList<Ingredient>)ingredients);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(recipe.getGroup());
        buffer.writeEnum((Enum)recipe.category());
        buffer.writeVarInt(recipe.getIngredients().size());
        for (Ingredient ingredient : recipe.getIngredients()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((ShapelessRecipeAccessor)recipe).getResult());
    }

    public T create(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        return this.factory.create(group, category, result, ingredients);
    }
}

