/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Math;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkBranch;

public final class PerkJailer
extends Perk {
    public PerkJailer(String name, PerkBranch branch, int branchTier, Supplier<ItemStack> icon) {
        super(name, branch, branchTier, icon);
    }

    @Override
    public int getLevelMax() {
        return 5 - (Integer)SharedConfigTombstone.magic_item.chanceEnchantedGraveKey.get() / 20;
    }

    @Override
    protected boolean isEnabledInConfig() {
        return (Integer)SharedConfigTombstone.magic_item.chanceEnchantedGraveKey.get() != -1 && (Integer)SharedConfigTombstone.magic_item.chanceEnchantedGraveKey.get() != 100;
    }

    @Override
    public Component getCurrentBonusInfo(int level) {
        return Component.literal((String)(Math.min((int)((Integer)SharedConfigTombstone.magic_item.chanceEnchantedGraveKey.get() + level * 20), (int)100) + "% ")).append((Component)Component.translatable((String)(this.getTranslationKey() + ".bonus")));
    }

    @Override
    public int getCost(int level) {
        return Math.max((int)1, (int)(level - 2));
    }

    @Override
    public int getLevelBonus(Player player) {
        return TimeHelper.isDateAroundHalloween() || TimeHelper.isDateAroundChristmas() ? 5 : 0;
    }
}

