/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;

public record CMessagePlayerCapSetPerk(@Nullable Perk perk, int level) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessagePlayerCapSetPerk> STREAM_CODEC = StreamCodec.ofMember(CMessagePlayerCapSetPerk::encode, CMessagePlayerCapSetPerk::decode);
    static final CustomPacketPayload.Type<CMessagePlayerCapSetPerk> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"player_cap_set_perk"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessagePlayerCapSetPerk decode(RegistryFriendlyByteBuf buf) {
        return new CMessagePlayerCapSetPerk(PerkRegistry.getValue(buf.readUtf()), buf.readByte() & 0xFF);
    }

    static void encode(CMessagePlayerCapSetPerk msg, RegistryFriendlyByteBuf buf) {
        buf.writeUtf(PerkRegistry.getStringKey(msg.perk));
        buf.writeByte(msg.level);
    }

    static void handle(CMessagePlayerCapSetPerk msg, IPayloadContext ctx) {
        if (msg.perk != null) {
            ProxyHelper.getClientPlayer().ifPresent(player -> {
                TBPlayerCapabilityHandler.setPerk(player, msg.perk, msg.level);
                Minecraft mc = Minecraft.getInstance();
                Screen patt0$temp = mc.screen;
                if (patt0$temp instanceof ScreenKnowledge) {
                    ScreenKnowledge screen = (ScreenKnowledge)patt0$temp;
                    screen.updatePerkIcons();
                }
            });
        }
    }
}

