/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.SpellCasterHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={Mob.class})
public class MobMixin {
    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsSunBurnTick(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (EntityHelper.isServant((Entity)((Mob)this))) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodCheckDespawn(CallbackInfo callbackInfo) {
        if (EntityHelper.isServant((Entity)((Mob)this))) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void methodTick(CallbackInfo callbackInfo) {
        Mob mob = (Mob)this;
        if (SpellCasterHandler.hasCapability((LivingEntity)mob)) {
            SpellCasterHandler.tick((LivingEntity)mob);
        }
    }

    @Inject(method={"canBeLeashed"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodCanBeLeashed(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        Mob mob = (Mob)this;
        if (!mob.isLeashed() && EntityHelper.isServant((Entity)mob)) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodSetTarget(@Nullable LivingEntity target, CallbackInfo callbackInfo) {
        if (target != null) {
            Mob attacker = (Mob)this;
            if (target.hasEffect(ModEffects.ghostly_shape) || target.hasEffect(ModEffects.diversion) || target.hasEffect(ModEffects.beyond_the_grave_bond) && attacker.getType().is(EntityTypeTags.UNDEAD)) {
                NeutralMob neutralMob;
                if (target.equals((Object)attacker.getLastHurtByMob())) {
                    attacker.setLastHurtByMob(null);
                }
                if (attacker instanceof NeutralMob && Optional.ofNullable((neutralMob = (NeutralMob)attacker).getPersistentAngerTarget()).map(uuid -> uuid.equals(target.getUUID())).orElse(false).booleanValue()) {
                    neutralMob.setPersistentAngerTarget(null);
                    neutralMob.setRemainingPersistentAngerTime(0);
                }
                if (attacker.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                    attacker.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, Optional.empty());
                }
                callbackInfo.cancel();
            }
        }
    }
}

