/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.UpdaterHandler;
import ovh.corail.tombstone.loot.CheckEnableFunction;
import ovh.corail.tombstone.loot.CheckPlayerCondition;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.EnchantedEquipmentFunction;
import ovh.corail.tombstone.loot.RandomInTagFunction;
import ovh.corail.tombstone.loot.RandomMagicTabletFunction;
import ovh.corail.tombstone.loot.RandomPotionFunction;
import ovh.corail.tombstone.loot.RandomScrollBuffFunction;
import ovh.corail.tombstone.loot.TriggerCatMorningFunction;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModPotions;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTriggers;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.GAME)
public final class LootHelper {
    private static final Map<TagKey<Item>, RandomWeightedItem> GENERATOR_BY_TAG = new ConcurrentHashMap<TagKey<Item>, RandomWeightedItem>();
    private static final Map<UpdaterHandler.PoolType, LootTable> CUSTOM_LOOTTABLES = new ConcurrentHashMap<UpdaterHandler.PoolType, LootTable>();
    @Nullable
    private static UpdaterHandler.LoottableList CHEST_LOOTTABLE = null;

    public static RandomWeightedItem getItemGenerator(TagKey<Item> tagKey) {
        return GENERATOR_BY_TAG.computeIfAbsent(tagKey, RandomWeightedItem::new);
    }

    public static void clear() {
        GENERATOR_BY_TAG.clear();
        CHEST_LOOTTABLE = null;
    }

    private static void addEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... lootItemFunctionBuilders) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)item).setQuality(0).setWeight(weight);
        if (item instanceof IDisableable) {
            lootBuilder.apply((LootItemFunction.Builder)new CheckEnableFunction.Builder());
        }
        for (LootItemFunction.Builder b : lootItemFunctionBuilders) {
            lootBuilder.apply(b);
        }
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addPotion(LootPool.Builder builder, Holder<Potion> potionHolder, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)Items.POTION).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)SetPotionFunction.setPotion(potionHolder));
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomPotion(LootPool.Builder builder, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)Items.POTION).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new RandomPotionFunction.Builder());
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addEnchantedEquipment(LootPool.Builder builder, EnchantedEquipmentFunction.Type equipmentType, int randomEnchantability, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)Items.BOOK).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new EnchantedEquipmentFunction.Builder(equipmentType, 50, randomEnchantability));
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomScrollBuff(LootPool.Builder builder, boolean isAncient, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)ModItems.strange_scroll).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new RandomScrollBuffFunction.Builder(isAncient));
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomMagicScroll(LootPool.Builder builder, boolean isAncient, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)ModItems.magic_scroll).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new DelayedNBTFunction.Builder());
        if (isAncient) {
            lootBuilder.apply((LootItemFunction.Builder)SetComponentsFunction.setComponent(ModDataComponents.ANCIENT, (Object)true));
        }
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomMagicTablet(LootPool.Builder builder, boolean isAncient, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)ModItems.strange_tablet).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new RandomMagicTabletFunction.Builder(isAncient));
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addRandomEnchantedBook(LootPool.Builder builder, int weight) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)Items.BOOK).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder());
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static void addDelayedNBTEntry(LootPool.Builder builder, Item item, int weight, LootItemFunction.Builder ... lootItemFunctionBuilders) {
        LootPoolSingletonContainer.Builder lootBuilder = LootItem.lootTableItem((ItemLike)item).setQuality(0).setWeight(weight);
        lootBuilder.apply((LootItemFunction.Builder)new DelayedNBTFunction.Builder());
        for (LootItemFunction.Builder b : lootItemFunctionBuilders) {
            lootBuilder.apply(b);
        }
        builder.add((LootPoolEntryContainer.Builder)lootBuilder);
    }

    private static LootPool getSnifferDigging() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:sniffer_digging");
        LootHelper.addEntry(builder, ModItems.grave_dust, 5, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight(95));
        return builder.build();
    }

    private static LootPool getSeekerRodLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:seeker_rod");
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 5, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, ModItems.receptacle_of_soul, 15, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 25, new LootItemFunction.Builder[0]);
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 25, new LootItemFunction.Builder[0]);
        LootHelper.addPotion(builder, ModPotions.restoration, 10);
        LootHelper.addRandomScrollBuff(builder, true, 20);
        return builder.build();
    }

    public static ItemStack getSeekerRodReward(ServerLevel level, BlockPos pos, Player player) {
        LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.GIFT);
        return LootHelper.getLootTable(UpdaterHandler.PoolType.SEEKER_ROD).getRandomItems(lootParams).stream().findFirst().orElse(new ItemStack((ItemLike)Items.GOLDEN_APPLE));
    }

    private static LootPool getLostTreasureLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:lost_treasure").when(CheckPlayerCondition.builder()).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)FishingHookPredicate.inOpenWater((boolean)true))));
        int weight = 0;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addEntry(builder, ModItems.ritual_flute, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addEntry(builder, Items.BOOK, 40, new LootItemFunction.Builder[]{new RandomInTagFunction.Builder((TagKey<Item>)ItemTags.DECORATED_POT_SHERDS)});
        weight += 40;
        LootHelper.addEntry(builder, Items.BUNDLE, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicTablet(builder, true, 15);
        weight += 15;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicScroll(builder, false, 50);
        weight += 50;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, (Item)ModItems.fishing_rod_of_misadventure, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.lost_tablet, 100, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight((weight += 100) * 10));
        return builder.build();
    }

    private static LootPool getArcheologyLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:archeology_treasure").when(CheckPlayerCondition.builder());
        int weight = 0;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.ritual_flute, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.receptacle_of_soul, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicTablet(builder, false, 300);
        weight += 300;
        LootHelper.addRandomMagicTablet(builder, true, 150);
        weight += 150;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 50, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight((weight += 50) * 10));
        return builder.build();
    }

    private static LootPool getChestTreasureLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:chest_treasure").when(CheckPlayerCondition.builder());
        builder.setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f));
        int weight = 0;
        LootHelper.addEntry(builder, Items.BUNDLE, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomScrollBuff(builder, false, 100);
        weight += 100;
        LootHelper.addDelayedNBTEntry(builder, ModItems.scroll_of_knowledge, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addRandomMagicTablet(builder, false, 50);
        weight += 50;
        LootHelper.addRandomMagicScroll(builder, false, 50);
        weight += 50;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.voodoo_poppet, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 10, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight((weight += 10) * 3));
        return builder.build();
    }

    private static LootPool getCatMorningLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:cat_morning");
        LootHelper.addEntry(builder, ModItems.grave_dust, 100, new LootItemFunction.Builder[]{new TriggerCatMorningFunction.Builder(), SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))});
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 1, new LootItemFunction.Builder[0]);
        LootHelper.addEntry(builder, Items.BUNDLE, 20, new LootItemFunction.Builder[0]);
        int weight = 121;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 20, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight((weight += 20) * 3));
        return builder.build();
    }

    private static LootPool getUndeadMobLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:undead_mob");
        int weight = 0;
        LootHelper.addEntry(builder, ModItems.grave_dust, 100, new LootItemFunction.Builder[]{SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))});
        weight += 100;
        LootHelper.addEntry(builder, Items.BUNDLE, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.bag_of_seeds, 10, new LootItemFunction.Builder[0]);
        weight += 10;
        LootHelper.addRandomMagicScroll(builder, false, 20);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 5, new LootItemFunction.Builder[0]);
        weight += 5;
        LootHelper.addEntry(builder, ModItems.ritual_flute, 5, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight((weight += 5) * 5));
        return builder.build();
    }

    private static LootPool getUndeadBossLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:undead_boss");
        int weight = 0;
        LootHelper.addRandomMagicScroll(builder, false, 100);
        weight += 100;
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.ritual_flute, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.gemstone_of_familiar, 20, new LootItemFunction.Builder[0]);
        weight += 20;
        LootHelper.addEntry(builder, ModItems.receptacle_of_soul, 100, new LootItemFunction.Builder[0]);
        weight += 100;
        LootHelper.addRandomScrollBuff(builder, true, 100);
        weight += 100;
        LootHelper.addRandomMagicScroll(builder, true, 50);
        weight += 50;
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 100, new LootItemFunction.Builder[0]);
        builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setQuality(0).setWeight((weight += 100) * 5));
        return builder.build();
    }

    private static LootPool getAbandonedGraveLootPool() {
        LootPool.Builder builder = LootPool.lootPool().name("tombstone:abandoned_grave");
        builder.setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f));
        LootHelper.addEntry(builder, ModItems.essence_of_undeath, 10, new LootItemFunction.Builder[0]);
        LootHelper.addDelayedNBTEntry(builder, ModItems.receptacle_of_familiar, 50, new LootItemFunction.Builder[0]);
        LootHelper.addRandomMagicScroll(builder, false, 200);
        LootHelper.addRandomMagicScroll(builder, true, 50);
        LootHelper.addRandomEnchantedBook(builder, 200);
        LootHelper.addEnchantedEquipment(builder, EnchantedEquipmentFunction.Type.WEAPON, 60, 100);
        LootHelper.addEnchantedEquipment(builder, EnchantedEquipmentFunction.Type.TOOL, 60, 100);
        LootHelper.addEnchantedEquipment(builder, EnchantedEquipmentFunction.Type.ARMOR, 60, 400);
        LootHelper.addRandomPotion(builder, 300);
        return builder.build();
    }

    public static void handleMobDrops(Collection<ItemEntity> drops, LivingEntity entity, ServerPlayer player, DamageSource damageSource) {
        if (EntityHelper.checkInvalidPlayerForLoot(player) || !player.level().dimension().equals(entity.level().dimension()) || entity.distanceToSqr((Entity)player) > 50.0) {
            return;
        }
        if (EntityHelper.isUndead(entity)) {
            LootParams.Builder builder = new LootParams.Builder(player.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity()).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player);
            LootParams context = builder.create(LootContextParamSets.ENTITY);
            boolean isBoss = EntityHelper.isBoss(entity);
            UpdaterHandler.PoolType poolType = isBoss ? UpdaterHandler.PoolType.UNDEAD_BOSS : UpdaterHandler.PoolType.UNDEAD_MOB;
            int rolls = (isBoss ? 5 : 1) + (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.treasure_seeker) * 20 ? 1 : 0);
            IntStream.range(0, rolls).forEach(i -> {
                ItemStack stack = LootHelper.getLootTable(poolType).getRandomItems(context).stream().findFirst().orElse(ItemStack.EMPTY);
                if (!stack.isEmpty()) {
                    if (stack.is((Item)ModItems.grave_dust)) {
                        ModTriggers.grave_dust_from_undead.trigger(player);
                    }
                    drops.add(new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), stack));
                }
            });
            if (Helper.RANDOM.nextInt(100) < 3) {
                List<ReadableScrollType> eligibleScrolls = Stream.of(ReadableScrollType.ELYRA_DIARY, ReadableScrollType.RITE_OF_SILENT_BOND).filter(type -> EntityHelper.getCustomStat(player, type.statRL.get()) < type.count).toList();
                Helper.getRandomInList(eligibleScrolls).ifPresent(type -> LootHelper.rewardReadableScroll(player, type, EntityHelper.getCustomStat(player, type.statRL.get()) + 1));
            }
        }
        if (TimeHelper.isDateAroundHalloween() && EntityHelper.isEnemy((Entity)entity) && Helper.RANDOM.nextInt(1000) < 50) {
            drops.add(new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), ModItems.lollipop.getRandomItemStack()));
        }
    }

    public static void rewardReadableScroll(ServerPlayer serverPlayer, ReadableScrollType readableScroll, int part) {
        if (part < 0) {
            return;
        }
        part = Math.min(part, readableScroll.count);
        EntityHelper.setCustomStat(serverPlayer, readableScroll.statRL.get(), part);
        ItemHandlerHelper.giveItemToPlayer((Player)serverPlayer, (ItemStack)ModItems.readable_scroll.createScroll(readableScroll.toString().toLowerCase(Locale.ROOT), part));
        (part == 4 ? LangKey.MESSAGE_WATCHER_KNOWLEDGE_FINAL_PROGRESS : LangKey.MESSAGE_WATCHER_KNOWLEDGE_PROGRESS).sendMessage((Player)serverPlayer, StyleType.MESSAGE_SPECIAL, new Object[0]);
    }

    public static LootTable getLootTable(UpdaterHandler.PoolType poolType) {
        return CUSTOM_LOOTTABLES.getOrDefault((Object)poolType, LootTable.EMPTY);
    }

    private static void attachLootPool(UpdaterHandler.PoolType poolType, LootTable lootTable) {
        LootPool lootPool = UpdaterHandler.instance.loadLootPool(poolType);
        if (lootPool == null) {
            lootPool = LootHelper.getDefaultLootPool(poolType);
            UpdaterHandler.instance.saveLootPool(poolType, lootPool);
        }
        lootTable.addPool(lootPool);
    }

    private static LootPool getDefaultLootPool(UpdaterHandler.PoolType poolType) {
        return switch (poolType) {
            default -> throw new MatchException(null, null);
            case UpdaterHandler.PoolType.ARCHAEOLOGY -> LootHelper.getArcheologyLootPool();
            case UpdaterHandler.PoolType.LOST_TREASURE -> LootHelper.getLostTreasureLootPool();
            case UpdaterHandler.PoolType.CAT_MORNING -> LootHelper.getCatMorningLootPool();
            case UpdaterHandler.PoolType.CHEST_TREASURE -> LootHelper.getChestTreasureLootPool();
            case UpdaterHandler.PoolType.UNDEAD_MOB -> LootHelper.getUndeadMobLootPool();
            case UpdaterHandler.PoolType.UNDEAD_BOSS -> LootHelper.getUndeadBossLootPool();
            case UpdaterHandler.PoolType.SEEKER_ROD -> LootHelper.getSeekerRodLootPool();
            case UpdaterHandler.PoolType.SNIFFER_DIGGING -> LootHelper.getSnifferDigging();
            case UpdaterHandler.PoolType.ABANDONED_GRAVE -> LootHelper.getAbandonedGraveLootPool();
        };
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getTable() == null || event.getName() == null) {
            return;
        }
        if (CHEST_LOOTTABLE == null) {
            CHEST_LOOTTABLE = UpdaterHandler.instance.loadChestLootTables();
        }
        if (event.getName().equals((Object)BuiltInLootTables.FISHING_JUNK.location())) {
            UpdaterHandler.PoolType[] poolTypes;
            for (UpdaterHandler.PoolType poolType : poolTypes = new UpdaterHandler.PoolType[]{UpdaterHandler.PoolType.ARCHAEOLOGY, UpdaterHandler.PoolType.UNDEAD_MOB, UpdaterHandler.PoolType.UNDEAD_BOSS, UpdaterHandler.PoolType.SEEKER_ROD, UpdaterHandler.PoolType.ABANDONED_GRAVE}) {
                LootTable lootTable = LootTable.lootTable().build();
                lootTable.setLootTableId(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)poolType.getFilename()));
                LootHelper.attachLootPool(poolType, lootTable);
                CUSTOM_LOOTTABLES.put(poolType, lootTable);
            }
            LootHelper.attachLootPool(UpdaterHandler.PoolType.LOST_TREASURE, event.getTable());
            ModTombstone.LOGGER.debug("Updating LootTables");
        } else if (event.getName().equals((Object)BuiltInLootTables.CAT_MORNING_GIFT.location())) {
            LootHelper.attachLootPool(UpdaterHandler.PoolType.CAT_MORNING, event.getTable());
        } else if (event.getName().equals((Object)BuiltInLootTables.SNIFFER_DIGGING.location())) {
            LootHelper.attachLootPool(UpdaterHandler.PoolType.SNIFFER_DIGGING, event.getTable());
        } else if (CHEST_LOOTTABLE.contains(event.getName())) {
            LootHelper.attachLootPool(UpdaterHandler.PoolType.CHEST_TREASURE, event.getTable());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDrops(LivingDropsEvent event) {
        Player player;
        if (event.getEntity() != null && !event.getEntity().level().isClientSide() && event.getEntity().getType() != EntityType.PLAYER && (player = event.getEntity().lastHurtByPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LootHelper.handleMobDrops(event.getDrops(), event.getEntity(), serverPlayer, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onReloadListener(AddReloadListenerEvent event) {
        LootHelper.clear();
    }

    public static enum ReadableScrollType {
        ELYRA_DIARY(() -> ModStats.ELYRA_DIARY, 4),
        RITE_OF_SILENT_BOND(() -> ModStats.RITE_OF_SILENT_BOND, 4),
        CORAL_CHANT(() -> ModStats.CORAL_CHANT, 4),
        ERDOS_FRAGMENTS(() -> ModStats.ERDOS_FRAGMENTS, 4);

        private final Supplier<ResourceLocation> statRL;
        private final int count;

        private ReadableScrollType(Supplier<ResourceLocation> statRL, int count) {
            this.statRL = statRL;
            this.count = count;
        }
    }
}

