/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.MoreObjects;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class Location
implements Comparable<Location> {
    private static final Comparator<Location> COMPARATOR = Comparator.comparing(Location::getDimRL).thenComparing(Location::getX).thenComparing(Location::getZ).thenComparing(Location::getY);
    public int x;
    public int y;
    public int z;
    public ResourceKey<Level> dim;
    static final BlockPos ORIGIN_POS = new BlockPos(0, Integer.MIN_VALUE, 0);
    public static final Location ORIGIN = new Location(ORIGIN_POS, (ResourceKey<Level>)Level.OVERWORLD);

    public Location(BlockPos pos, ResourceKey<Level> dim) {
        this(pos.getX(), pos.getY(), pos.getZ(), dim);
    }

    public Location(BlockPos pos, Level level) {
        this(pos.getX(), pos.getY(), pos.getZ(), level);
    }

    public Location(int x, int y, int z, Level level) {
        this(x, y, z, (ResourceKey<Level>)level.dimension());
    }

    public Location(int x, int y, int z, ResourceKey<Level> dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public Location(GlobalPos globalPos) {
        this(globalPos.pos(), (ResourceKey<Level>)globalPos.dimension());
    }

    public Location(Entity entity) {
        this(entity.blockPosition(), entity.level());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public ResourceLocation getDimRL() {
        return this.dim.location();
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public GlobalPos asGlobalPos() {
        return GlobalPos.of(this.dim, (BlockPos)this.getPos());
    }

    public Location set(int x, int y, int z, ResourceKey<Level> dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
        return this;
    }

    public Location move(Direction direction, int length) {
        Vec3i vec = direction.getNormal();
        this.x += vec.getX() * length;
        this.y += vec.getY() * length;
        this.z += vec.getZ() * length;
        return this;
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public boolean isSameDimension(Level world) {
        return this.dim.equals((Object)world.dimension());
    }

    public boolean isSameDimension(String worldRL) {
        return this.getDimString().equals(worldRL);
    }

    public double getDistanceSq(Location location) {
        return this.getDistanceSq(location.getPos());
    }

    public double getDistanceSq(BlockPos pos) {
        double d0 = this.x - pos.getX();
        double d1 = this.y - pos.getY();
        double d2 = this.z - pos.getZ();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isInRangeAndDimension(Location loc, int range) {
        return this.isInRange(loc, range) && this.dim.equals(loc.dim);
    }

    public boolean isInRange(int x, int y, int z, int range) {
        return this.isInRange(new Location(x, y, z, this.dim), range);
    }

    public boolean isInRange(BlockPos position, int range) {
        return this.getDistanceSq(position) <= (double)(range * range);
    }

    public boolean isInRange(Location location, int range) {
        return this.getDistanceSq(location) <= (double)(range * range);
    }

    public String getDimString() {
        return this.dim.location().toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", (Object)this.getDimString()).toString();
    }

    @Override
    public int compareTo(Location location) {
        return COMPARATOR.compare(this, location);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Location location = (Location)o;
            return this.x == location.x && this.y == location.y && this.z == location.z && this.dim.location().equals((Object)location.dim.location());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dim.location(), this.x, this.y, this.z);
    }
}

