/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModBlocks;

public final class IntegrationTOP
implements Function<ITheOneProbe, Void> {
    private static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"top");
    private static final Map<Block, List<IElement>> ELEMENTS = new HashMap<Block, List<IElement>>();
    private static boolean FAILED = false;

    private void setElements(BlockGrave grave, IProbeInfo probeInfo) {
        List oldElements = probeInfo.getElements();
        List<IElement> cache = ELEMENTS.get((Object)grave);
        if (cache == null) {
            ItemStack stack = grave.asDecorativeStack();
            if (!stack.isEmpty()) {
                ArrayList toKeep = oldElements.size() == 1 ? new ArrayList() : IntStream.range(1, oldElements.size()).mapToObj(oldElements::get).collect(Collectors.toList());
                oldElements.clear();
                ILayoutStyle layout = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT).spacing(2);
                probeInfo.horizontal(layout).item(stack).vertical(layout).itemLabel(stack).text(String.valueOf(ChatFormatting.BLUE) + ChatFormatting.ITALIC.toString() + "Corail Tombstone");
                probeInfo.getElements().addAll(toKeep);
                ELEMENTS.put((Block)grave, new ArrayList(probeInfo.getElements()));
            }
        } else {
            oldElements.clear();
            oldElements.addAll(cache);
        }
    }

    @Override
    public Void apply(ITheOneProbe probe) {
        ModTombstone.LOGGER.info("Integration TOP");
        try {
            probe.registerProvider(new IProbeInfoProvider(){

                public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
                    if (FAILED || level.isClientSide()) {
                        return;
                    }
                    try {
                        if (ModBlocks.isPlayerGrave(blockState.getBlock())) {
                            IntegrationTOP.this.setElements((BlockGrave)blockState.getBlock(), iProbeInfo);
                            Helper.getPlayerGrave(level, iProbeHitData.getPos()).ifPresent(grave -> {
                                iProbeInfo.text(grave.getFormattedInfo());
                                iProbeInfo.text(grave.getFormattedDeathDate());
                            });
                        } else if (ModBlocks.isDecorativeGrave(blockState.getBlock())) {
                            Helper.getDecorativeGrave(level, iProbeHitData.getPos()).ifPresent(grave -> {
                                int corruption = grave.getCorruptionLevel();
                                iProbeInfo.text((Component)LangKey.TOOLTIP_CORRUPTION.getText(corruption < 30 ? StyleType.COLOR_GREEN : (corruption > 70 ? StyleType.COLOR_RED : StyleType.COLOR_ORANGE), new Object[]{corruption}));
                            });
                        }
                    }
                    catch (Throwable t) {
                        ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
                        FAILED = true;
                    }
                }

                public ResourceLocation getID() {
                    return RL;
                }
            });
        }
        catch (Throwable t) {
            ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
            FAILED = true;
        }
        return null;
    }
}

