/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.kfnp.shared.network.util;

import io.netty.buffer.ByteBuf;

public class VarLongUtil {
    public static final long MASK_7_BITS = -128L;
    public static final long MASK_14_BITS = -16384L;
    public static final long MASK_21_BITS = -2097152L;
    public static final long MASK_28_BITS = -268435456L;
    public static final long MASK_35_BITS = -34359738368L;
    public static final long MASK_42_BITS = -4398046511104L;
    private static final long CONTINUATION_BIT = 128L;
    private static final long DATA_MASK = 127L;
    private static final int[] VARLONG_EXACT_BYTE_LENGTHS = new int[65];

    public static int getVarLongLength(long data) {
        return VARLONG_EXACT_BYTE_LENGTHS[Long.numberOfLeadingZeros(data)];
    }

    public static void writeVarLongFull(ByteBuf buffer, long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            buffer.writeByte((int)value);
        } else if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            buffer.writeShort((int)(value & 0x7FL | 0x80L) << 8 | (int)(value >>> 7));
        } else if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            int encoded3 = (int)(value & 0x7FL | 0x80L) << 16 | (int)(value >>> 7 & 0x7FL | 0x80L) << 8 | (int)(value >>> 14);
            buffer.writeMedium(encoded3);
        } else if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            int encoded4 = (int)(value & 0x7FL | 0x80L) << 24 | (int)(value >>> 7 & 0x7FL | 0x80L) << 16 | (int)(value >>> 14 & 0x7FL | 0x80L) << 8 | (int)(value >>> 21);
            buffer.writeInt(encoded4);
        } else if ((value & 0xFFFFFFF800000000L) == 0L) {
            int first45 = (int)(value & 0x7FL | 0x80L) << 24 | (int)(value >>> 7 & 0x7FL | 0x80L) << 16 | (int)(value >>> 14 & 0x7FL | 0x80L) << 8 | (int)(value >>> 21 & 0x7FL | 0x80L);
            buffer.writeInt(first45);
            buffer.writeByte((int)(value >>> 28));
        } else if ((value & 0xFFFFFC0000000000L) == 0L) {
            int first46 = (int)(value & 0x7FL | 0x80L) << 24 | (int)(value >>> 7 & 0x7FL | 0x80L) << 16 | (int)(value >>> 14 & 0x7FL | 0x80L) << 8 | (int)(value >>> 21 & 0x7FL | 0x80L);
            int last26 = (int)(value >>> 28 & 0x7FL | 0x80L) << 8 | (int)(value >>> 35);
            buffer.writeInt(first46);
            buffer.writeShort(last26);
        } else {
            int length = VarLongUtil.getVarLongLength(value);
            switch (length) {
                case 7: {
                    int first47 = (int)(value & 0x7FL | 0x80L) << 24 | (int)(value >>> 7 & 0x7FL | 0x80L) << 16 | (int)(value >>> 14 & 0x7FL | 0x80L) << 8 | (int)(value >>> 21 & 0x7FL | 0x80L);
                    int last37 = (int)(value >>> 28 & 0x7FL | 0x80L) << 16 | (int)(value >>> 35 & 0x7FL | 0x80L) << 8 | (int)(value >>> 42);
                    buffer.writeInt(first47);
                    buffer.writeMedium(last37);
                    break;
                }
                case 8: {
                    int first48 = (int)(value & 0x7FL | 0x80L) << 24 | (int)(value >>> 7 & 0x7FL | 0x80L) << 16 | (int)(value >>> 14 & 0x7FL | 0x80L) << 8 | (int)(value >>> 21 & 0x7FL | 0x80L);
                    int last48 = (int)(value >>> 28 & 0x7FL | 0x80L) << 24 | (int)(value >>> 35 & 0x7FL | 0x80L) << 16 | (int)(value >>> 42 & 0x7FL | 0x80L) << 8 | (int)(value >>> 49);
                    buffer.writeInt(first48);
                    buffer.writeInt(last48);
                    break;
                }
                case 9: {
                    buffer.writeLong(VarLongUtil.getFirst8(value));
                    buffer.writeByte((int)(value >>> 56));
                    break;
                }
                case 10: {
                    int last2 = (int)(value >>> 56 & 0x7FL | 0x80L) << 8 | (int)(value >>> 63);
                    buffer.writeLong(VarLongUtil.getFirst8(value));
                    buffer.writeShort(last2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid VarLong length: " + length);
                }
            }
        }
    }

    public static long getFirst8(long value) {
        return (value & 0x7FL | 0x80L) << 56 | (value >>> 7 & 0x7FL | 0x80L) << 48 | (value >>> 14 & 0x7FL | 0x80L) << 40 | (value >>> 21 & 0x7FL | 0x80L) << 32 | (value >>> 28 & 0x7FL | 0x80L) << 24 | (value >>> 35 & 0x7FL | 0x80L) << 16 | (value >>> 42 & 0x7FL | 0x80L) << 8 | (value >>> 49 & 0x7FL | 0x80L);
    }

    static {
        for (int i = 0; i < 64; ++i) {
            int s = 64 - i;
            VarLongUtil.VARLONG_EXACT_BYTE_LENGTHS[i] = (s + 6) / 7;
        }
        VarLongUtil.VARLONG_EXACT_BYTE_LENGTHS[64] = 1;
    }
}

