/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.kfnp.mixin.network.thread;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLoginPacketListenerImpl.class}, priority=900)
public abstract class ServerLoginPacketListenerImplMixin {
    @Final
    @Shadow
    static Logger LOGGER;
    @Final
    @Shadow
    private static AtomicInteger UNIQUE_THREAD_ID;
    @Final
    @Shadow
    Connection connection;
    @Final
    @Shadow
    MinecraftServer server;
    @Shadow
    String requestedUsername;

    @Invoker(value="startClientVerification")
    abstract void krypton_Multi$startClientVerification(GameProfile var1);

    @Invoker(value="disconnect")
    abstract void krypton_Multi$disconnect(Component var1);

    @Inject(method={"handleKey"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;setEncryptionKey(Ljavax/crypto/Cipher;Ljavax/crypto/Cipher;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void krypton_Multi$cacheAuthenticatorThread(ServerboundKeyPacket packet, CallbackInfo ci, @Local String s) {
        Runnable runnable = () -> {
            String s1 = Objects.requireNonNull(this.requestedUsername, "Player name not initialized");
            try {
                ProfileResult profileresult = this.server.getSessionService().hasJoinedServer(s1, s, this.krypton_Multi$getAddress());
                if (profileresult != null) {
                    GameProfile gameprofile = profileresult.profile();
                    LOGGER.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
                    this.krypton_Multi$startClientVerification(gameprofile);
                } else if (this.server.isSingleplayer()) {
                    LOGGER.warn("Failed to verify username but will let them in anyway!");
                    this.krypton_Multi$startClientVerification(UUIDUtil.createOfflineProfile((String)s1));
                } else {
                    this.krypton_Multi$disconnect((Component)Component.translatable((String)"multiplayer.disconnect.unverified_username"));
                    LOGGER.error("Username '{}' tried to join with an invalid session", (Object)s1);
                }
            }
            catch (AuthenticationUnavailableException authenticationunavailableexception) {
                if (this.server.isSingleplayer()) {
                    LOGGER.warn("Authentication servers are down but will let them in anyway!");
                    this.krypton_Multi$startClientVerification(UUIDUtil.createOfflineProfile((String)s1));
                }
                this.krypton_Multi$disconnect((Component)Component.translatable((String)"multiplayer.disconnect.authservers_down"));
                LOGGER.error("Couldn't verify username because servers are unavailable");
            }
        };
        Thread.ofVirtual().name("User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()).uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).start(runnable);
        ci.cancel();
    }

    @Unique
    private InetAddress krypton_Multi$getAddress() {
        SocketAddress socketaddress = this.connection.getRemoteAddress();
        return this.server.getPreventProxyConnections() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
    }
}

