/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.kfnp.mixin.network.pipeline.compression;

import com.velocitypowered.natives.compression.JavaVelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.Natives;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.CompressionEncoder;
import net.minecraft.network.Connection;
import one.pkg.kfnp.shared.ModConfig;
import one.pkg.kfnp.shared.misc.KryptonPipelineEvent;
import one.pkg.kfnp.shared.network.compression.MinecraftCompressDecoder;
import one.pkg.kfnp.shared.network.compression.MinecraftCompressEncoder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public class ConnectionMixin {
    @Shadow
    private Channel channel;

    @Unique
    private static boolean krypton_fnp$isKryptonOrVanillaDecompressor(Object o) {
        return o instanceof CompressionEncoder || o instanceof MinecraftCompressDecoder;
    }

    @Unique
    private static boolean krypton_fnp$isKryptonOrVanillaCompressor(Object o) {
        return o instanceof CompressionDecoder || o instanceof MinecraftCompressEncoder;
    }

    @Inject(method={"setupCompression"}, at={@At(value="HEAD")}, cancellable=true)
    public void setCompressionThreshold(int threshold, boolean validateDecompressed, CallbackInfo ci) {
        if (threshold < 0) {
            if (ConnectionMixin.krypton_fnp$isKryptonOrVanillaDecompressor(this.channel.pipeline().get("decompress"))) {
                this.channel.pipeline().remove("decompress");
            }
            if (ConnectionMixin.krypton_fnp$isKryptonOrVanillaCompressor(this.channel.pipeline().get("compress"))) {
                this.channel.pipeline().remove("compress");
            }
            this.channel.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_DISABLED);
        } else {
            MinecraftCompressDecoder decoder = (MinecraftCompressDecoder)this.channel.pipeline().get("decompress");
            MinecraftCompressEncoder encoder = (MinecraftCompressEncoder)this.channel.pipeline().get("compress");
            if (decoder != null && encoder != null) {
                decoder.setThreshold(threshold);
                encoder.setThreshold(threshold);
                this.channel.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_THRESHOLD_UPDATED);
            } else {
                VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(ModConfig.Compression.getLevel());
                VelocityCompressor jCompressor = !ModConfig.Compression.BlendingMode.isEnabled() && compressor instanceof JavaVelocityCompressor ? null : JavaVelocityCompressor.FACTORY.create(ModConfig.Compression.getLevel());
                encoder = new MinecraftCompressEncoder(threshold, compressor, jCompressor);
                decoder = new MinecraftCompressDecoder(threshold, validateDecompressed, compressor, jCompressor);
                this.channel.pipeline().addBefore("decoder", "decompress", (ChannelHandler)decoder);
                this.channel.pipeline().addBefore("encoder", "compress", (ChannelHandler)encoder);
                this.channel.pipeline().fireUserEventTriggered((Object)KryptonPipelineEvent.COMPRESSION_ENABLED);
            }
        }
        ci.cancel();
    }
}

