/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.kfnp.mixin.network.microopt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={Utf8String.class})
public class Utf8StringMixin {
    @Overwrite
    public static void write(ByteBuf buf, CharSequence string, int length) {
        int maxBytesPermitted;
        if (string.length() > length) {
            throw new EncoderException("String too big (was " + string.length() + " characters, max " + length + ")");
        }
        int utf8Bytes = ByteBufUtil.utf8Bytes((CharSequence)string);
        if (utf8Bytes > (maxBytesPermitted = ByteBufUtil.utf8MaxBytes((int)length))) {
            throw new EncoderException("String too big (was " + utf8Bytes + " bytes encoded, max " + maxBytesPermitted + ")");
        }
        VarInt.write((ByteBuf)buf, (int)utf8Bytes);
        buf.writeCharSequence(string, StandardCharsets.UTF_8);
    }
}

