/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.kfnp.mixin.network.experimental;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import net.minecraft.server.rcon.thread.RconClient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={RconClient.class})
public class RconClientMixin {
    @Unique
    private static final int CHUNK_SIZE = 4096;
    @Unique
    private static final int PACKET_OVERHEAD = 10;
    @Unique
    private final byte[] krypton_fnp$chunkBuffer = new byte[4096];
    @Shadow
    @Final
    private Socket client;

    @Shadow
    private void closeSocket() {
    }

    @Overwrite
    private void send(int id, int type, String message) throws IOException {
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        this.send(id, type, bytes, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void send(int id, int type, byte[] messageBytes, int length) throws IOException {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(length + 10 + 2);
        try {
            buf.writeIntLE(length + 10);
            buf.writeIntLE(id);
            buf.writeIntLE(type);
            buf.writeBytes(messageBytes, 0, length);
            buf.writeByte(0);
            buf.writeByte(0);
            if (buf.hasArray()) {
                this.client.getOutputStream().write(buf.array(), buf.arrayOffset() + buf.readerIndex(), buf.readableBytes());
            } else {
                byte[] temp = new byte[buf.readableBytes()];
                buf.getBytes(buf.readerIndex(), temp);
                this.client.getOutputStream().write(temp);
            }
        }
        finally {
            buf.release();
        }
    }

    @Overwrite
    private void sendCmdResponse(int id, String message) throws IOException {
        byte[] fullBytes = message.getBytes(StandardCharsets.UTF_8);
        int len = fullBytes.length;
        if (len <= 4096) {
            this.send(id, 0, fullBytes, len);
        } else {
            int chunkSize;
            for (int offset = 0; offset < len; offset += chunkSize) {
                chunkSize = Math.min(4096, len - offset);
                System.arraycopy(fullBytes, offset, this.krypton_fnp$chunkBuffer, 0, chunkSize);
                this.send(id, 0, this.krypton_fnp$chunkBuffer, chunkSize);
            }
        }
    }
}

