/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MICommonProxy;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariantAttributes;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class FluidHelper {
    public static Component getFluidName(FluidVariant fluid, boolean grayIfEmpty) {
        if (fluid.isBlank()) {
            Style style = grayIfEmpty ? Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(false)) : Style.EMPTY;
            return MIText.Empty.text().setStyle(style);
        }
        return FluidVariantAttributes.getName(fluid);
    }

    public static MutableComponent getFluidAmount(long amount, long capacity) {
        if (capacity < 100000L || MICommonProxy.INSTANCE.hasShiftDown()) {
            String text = amount + " / " + capacity;
            return Component.literal((String)(text + " mB"));
        }
        TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount((double)amount / 1000.0, (double)capacity / 1000.0);
        return Component.literal((String)(maxedAmount.digit() + " / " + maxedAmount.maxDigit() + " " + maxedAmount.unit() + "B"));
    }

    public static MutableComponent getFluidAmount(long amount) {
        if (amount < 100000L || MICommonProxy.INSTANCE.hasShiftDown()) {
            String text = String.valueOf(amount);
            return Component.literal((String)(text + " mB"));
        }
        return FluidHelper.getFluidAmountLarge(amount);
    }

    public static MutableComponent getFluidAmountLarge(long amount) {
        TextHelper.Amount amountUnit = TextHelper.getAmount((double)amount / 1000.0);
        return Component.literal((String)(amountUnit.digit() + " " + amountUnit.unit() + "B"));
    }

    public static int getColorMinLuminance(int color) {
        int r = color & 0xFF;
        int g = (color & 0xFF00) >> 8;
        int b = (color & 0xFF0000) >> 16;
        double lum = (0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b) / 255.0;
        if (lum < 0.3) {
            if (lum == 0.0) {
                return 0x4C4C4C;
            }
            r = Math.min((int)((double)r * 0.3 / lum), 255);
            g = Math.min((int)((double)g * 0.3 / lum), 255);
            b = Math.min((int)((double)b * 0.3 / lum), 255);
            return r + (g << 8) + (b << 16);
        }
        return color;
    }

    public static List<Component> getTooltip(FluidVariant fluid, boolean grayIfEmpty) {
        if (fluid.isBlank()) {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add(FluidHelper.getFluidName(fluid, grayIfEmpty));
            return list;
        }
        return MICommonProxy.INSTANCE.getFluidTooltip(fluid);
    }

    public static List<Component> getTooltipForFluidStorage(FluidVariant fluid, long amount, long capacity, boolean grayIfEmpty) {
        List<Component> tooltip = FluidHelper.getTooltip(fluid, grayIfEmpty);
        tooltip.add((Component)FluidHelper.getFluidAmount(amount, capacity));
        return tooltip;
    }

    public static List<Component> getTooltipForFluidStorage(FluidVariant fluid, long amount, long capacity) {
        return FluidHelper.getTooltipForFluidStorage(fluid, amount, capacity, true);
    }
}

