/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import com.google.common.primitives.Ints;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public record SlotItemHandler(SingleSlotStorage<ItemVariant> storage) implements IItemHandler
{
    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ((ItemVariant)this.storage.getResource()).toStack(Ints.saturatedCast((long)this.storage.getAmount()));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return stack;
        }
        try (Transaction tx = Transaction.hackyOpen();){
            long inserted = this.storage.insert(ItemVariant.of(stack), stack.getCount(), tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = inserted == 0L ? stack : stack.copyWithCount(stack.getCount() - (int)inserted);
            return itemStack;
        }
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        try (Transaction tx = Transaction.hackyOpen();){
            ItemVariant resource = (ItemVariant)this.storage.getResource();
            if (resource.isBlank()) {
                ItemStack itemStack = ItemStack.EMPTY;
                return itemStack;
            }
            long extracted = this.storage.extract(resource, amount, tx);
            if (!simulate) {
                tx.commit();
            }
            ItemStack itemStack = extracted == 0L ? ItemStack.EMPTY : resource.toStack((int)extracted);
            return itemStack;
        }
    }

    public int getSlotLimit(int slot) {
        return Ints.saturatedCast((long)this.storage.getCapacity());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

