/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.machines.components.NuclearEfficiencyHistoryComponent;
import aztech.modern_industrialization.nuclear.NeutronFate;
import aztech.modern_industrialization.nuclear.NeutronInteraction;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.nuclear.NuclearGrid;
import aztech.modern_industrialization.nuclear.NuclearTile;
import java.util.Optional;
import java.util.Random;
import org.jspecify.annotations.Nullable;

public class NuclearGridHelper {
    private static final int[] dX = new int[]{1, 0, -1, 0};
    private static final int[] dY = new int[]{0, 1, 0, -1};
    private static final Random rand = new Random();
    private static final int MAX_SPLIT = 30;

    public static boolean simulate(NuclearGrid grid, NuclearEfficiencyHistoryComponent efficiencyHistory) {
        NuclearTile secondTile;
        int sizeX = grid.getSizeX();
        int sizeY = grid.getSizeY();
        boolean hasFuel = false;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                int x = i;
                int y = j;
                @Nullable NuclearTile tile = grid.getNuclearTile(i, j);
                if (tile == null) continue;
                Optional<NuclearFuel> maybeFuel = tile.getFuel();
                int neutronNumberPrime = tile.neutronGenerationTick(efficiencyHistory);
                if (neutronNumberPrime == 0) continue;
                hasFuel = true;
                NuclearFuel fuel = maybeFuel.orElseThrow(() -> new IllegalStateException("Neutron generated without fuel"));
                tile.putHeat((double)(neutronNumberPrime * fuel.directEUbyDesintegration) / fuel.neutronMultiplicationFactor);
                int split = Math.min(neutronNumberPrime, 30);
                int neutronNumberPerSplit = neutronNumberPrime / split;
                block2: for (int k = 0; k < split + 1; ++k) {
                    int neutronNumber;
                    int n = neutronNumber = k < split ? neutronNumberPerSplit : neutronNumberPrime % split;
                    if (neutronNumber <= 0) continue;
                    NeutronType type = NeutronType.FAST;
                    grid.registerNeutronCreation(neutronNumber, type);
                    int dir = rand.nextInt(4);
                    int posX = x;
                    int posY = y;
                    while (true) {
                        if ((secondTile = grid.getNuclearTile(posX, posY)) == null) {
                            grid.registerNeutronFate(neutronNumber, type, NeutronFate.ESCAPE);
                            continue block2;
                        }
                        secondTile.addNeutronsToFlux(neutronNumber, type);
                        @Nullable NuclearComponent<?> component = secondTile.getComponent();
                        if (component != null) {
                            double interactionProba = component.getNeutronBehaviour().interactionTotalProbability(type);
                            if (rand.nextDouble() < interactionProba) {
                                double probaAbsorption;
                                double interactionSelector = rand.nextDouble();
                                if (interactionSelector <= (probaAbsorption = component.getNeutronBehaviour().interactionRelativeProbability(type, NeutronInteraction.ABSORPTION))) {
                                    secondTile.absorbNeutrons(neutronNumber, type);
                                    if (type == NeutronType.FAST) {
                                        secondTile.putHeat(neutronNumber * 8);
                                    }
                                    if (secondTile.getFuel().isPresent()) {
                                        grid.registerNeutronFate(neutronNumber, type, NeutronFate.ABSORBED_IN_FUEL);
                                        continue block2;
                                    }
                                    grid.registerNeutronFate(neutronNumber, type, NeutronFate.ABSORBED_NOT_IN_FUEL);
                                    continue block2;
                                }
                                dir = rand.nextInt(4);
                                if (type == NeutronType.FAST && rand.nextDouble() < component.getNeutronBehaviour().neutronSlowingProbability()) {
                                    type = NeutronType.THERMAL;
                                    secondTile.putHeat(neutronNumber * 8);
                                }
                            }
                        }
                        posX += dX[dir];
                        posY += dY[dir];
                    }
                }
            }
        }
        double[][] heatTransferCoeff = new double[grid.getSizeX()][grid.getSizeY()];
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                @Nullable NuclearTile tile = grid.getNuclearTile(i, j);
                if (tile == null) continue;
                heatTransferCoeff[i][j] = tile.getHeatTransferCoeff();
            }
        }
        int NUMERICAL_SUBSTEP = 10;
        for (int substep = 0; substep < 10; ++substep) {
            double[][] temperatureOut = new double[sizeX][sizeY];
            double[][] temperatureDelta = new double[sizeX][sizeY];
            for (int step = 0; step < 3; ++step) {
                for (int i = 0; i < sizeX; ++i) {
                    for (int j = 0; j < sizeY; ++j) {
                        @Nullable NuclearTile tile = grid.getNuclearTile(i, j);
                        if (tile == null) continue;
                        double temperatureA = tile.getTemperature();
                        if (step == 2) {
                            tile.setTemperature(temperatureA + temperatureDelta[i][j]);
                            continue;
                        }
                        double coeffA = heatTransferCoeff[i][j];
                        if (step == 1) {
                            double[] dArray = temperatureDelta[i];
                            int n = j;
                            dArray[n] = dArray[n] - Math.min(temperatureA, temperatureOut[i][j]);
                        }
                        for (int k = 0; k < 4; ++k) {
                            double temperatureB;
                            int i2 = i + dX[k];
                            int j2 = j + dY[k];
                            secondTile = grid.getNuclearTile(i2, j2);
                            if (secondTile != null) {
                                temperatureB = secondTile.getTemperature();
                                double coeffB = heatTransferCoeff[i2][j2];
                                double coeffTransfer = 0.5 * (coeffA + coeffB) / 10.0;
                                if (!(temperatureA > temperatureB)) continue;
                                if (step == 0) {
                                    double[] dArray = temperatureOut[i];
                                    int n = j;
                                    dArray[n] = dArray[n] + (temperatureA - temperatureB) * coeffTransfer;
                                    continue;
                                }
                                double frac = Math.min(1.0, temperatureA / temperatureOut[i][j]);
                                double[] dArray = temperatureDelta[i2];
                                int n = j2;
                                dArray[n] = dArray[n] + frac * (temperatureA - temperatureB) * coeffTransfer;
                                continue;
                            }
                            temperatureB = 0.0;
                            double coeffTransfer = 0.5 * coeffA / 10.0;
                            if (step != 0) continue;
                            double[] dArray = temperatureOut[i];
                            int n = j;
                            dArray[n] = dArray[n] + (temperatureA - temperatureB) * coeffTransfer;
                        }
                    }
                }
            }
        }
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                @Nullable NuclearTile maybeTile = grid.getNuclearTile(i, j);
                if (maybeTile == null) continue;
                maybeTile.nuclearTick(efficiencyHistory);
            }
        }
        return hasFuel;
    }
}

