/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.nuclear.IsotopeParams;
import aztech.modern_industrialization.nuclear.NeutronBehaviour;

public class IsotopeFuelParams
extends IsotopeParams {
    public final int maxTemp;
    public final double neutronsMultiplication;
    public final double directEnergyFactor;
    public final int tempLimitLow;
    public final int tempLimitHigh;

    public IsotopeFuelParams(double thermalAbsorbProba, double thermalScatterings, int maxTemp, int tempLimitLow, int tempLimitHigh, double neutronsMultiplication, double directEnergyFactor) {
        super(thermalAbsorbProba, NeutronBehaviour.reduceCrossProba(thermalAbsorbProba, 0.1), thermalScatterings, NeutronBehaviour.reduceCrossProba(thermalScatterings, 0.5));
        this.maxTemp = maxTemp;
        this.neutronsMultiplication = neutronsMultiplication;
        this.directEnergyFactor = directEnergyFactor;
        this.tempLimitLow = tempLimitLow;
        this.tempLimitHigh = tempLimitHigh;
    }

    public static IsotopeFuelParams of(Material material) {
        IsotopeFuelParams params = material.get(MaterialProperty.ISOTOPE);
        if (params == null) {
            throw new IllegalArgumentException("Material %s must be a fuel isotope".formatted(material.name));
        }
        return params;
    }

    public static IsotopeFuelParams mix(Material a, Material b, double factor) {
        return IsotopeFuelParams.mix(IsotopeFuelParams.of(a), IsotopeFuelParams.of(b), factor);
    }

    public static IsotopeFuelParams mix(IsotopeFuelParams a, IsotopeFuelParams b, double factor) {
        factor = 1.0 - factor;
        double newThermalAbsorptionProba = NeutronBehaviour.probaFromCrossSection(IsotopeFuelParams.mix(a.thermalAbsorption, b.thermalAbsorption, factor));
        double newScatteringProba = NeutronBehaviour.probaFromCrossSection(IsotopeFuelParams.mix(a.thermalScattering, b.thermalScattering, factor));
        double newNeutronMultiplicationFactor = IsotopeFuelParams.mix(a.neutronsMultiplication, b.neutronsMultiplication, factor);
        double totalEnergy = IsotopeFuelParams.mix(a.neutronsMultiplication * (1.0 + a.directEnergyFactor), b.neutronsMultiplication * (1.0 + b.directEnergyFactor), factor);
        int newMaxTemp = (int)IsotopeFuelParams.mix(a.maxTemp, b.maxTemp, factor);
        int newTempLimitLow = (int)IsotopeFuelParams.mix(a.tempLimitLow, b.tempLimitLow, factor);
        int newTempLimitHigh = (int)IsotopeFuelParams.mix(a.tempLimitHigh, b.tempLimitHigh, factor);
        double newDirectEnergyFactor = totalEnergy / newNeutronMultiplicationFactor - 1.0;
        return new IsotopeFuelParams(newThermalAbsorptionProba, newScatteringProba, newMaxTemp, newTempLimitLow, newTempLimitHigh, newNeutronMultiplicationFactor, newDirectEnergyFactor);
    }

    private static double mix(double a, double b, double r) {
        return r * a + (1.0 - r) * b;
    }
}

