/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class ShapeSelection
implements GuiComponentServer<List<LineInfo>, List<Integer>> {
    public static final GuiComponentServer.Type<List<LineInfo>, List<Integer>> TYPE = new GuiComponentServer.Type(MI.id("shape_selection"), LineInfo.STREAM_CODEC.apply(ByteBufCodecs.list()), ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()));
    public final Behavior behavior;
    private final List<LineInfo> lines;

    public ShapeSelection(Behavior behavior, LineInfo ... lines) {
        Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0);
        this.behavior = behavior;
        this.lines = List.of(lines);
    }

    @Override
    public List<LineInfo> getParams() {
        return this.lines;
    }

    @Override
    public List<Integer> extractData() {
        return IntStream.range(0, this.lines.size()).map(this.behavior::getCurrentIndex).boxed().toList();
    }

    @Override
    public GuiComponentServer.Type<List<LineInfo>, List<Integer>> getType() {
        return TYPE;
    }

    public static interface Behavior {
        public void handleClick(int var1, int var2);

        public int getCurrentIndex(int var1);
    }

    public record LineInfo(List<Component> translations, boolean useArrows) {
        public static final StreamCodec<RegistryFriendlyByteBuf, LineInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), LineInfo::translations, (StreamCodec)ByteBufCodecs.BOOL, LineInfo::useArrows, LineInfo::new);

        public int numValues() {
            return this.translations.size();
        }
    }
}

