/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Unit;

public class CraftingMultiblockGui
implements GuiComponentServer<Unit, Data> {
    public static final GuiComponentServer.Type<Unit, Data> TYPE = new GuiComponentServer.Type(MI.id("crafting_multiblock_gui"), StreamCodec.unit((Object)Unit.INSTANCE), Data.STREAM_CODEC);
    private final CrafterComponent crafter;
    private final Supplier<Boolean> isShapeValid;
    private final Supplier<Float> progressSupplier;
    private final IntSupplier remainingOverclockTicks;
    public static final int X = 5;
    public static final int Y = 16;
    public static final int W = 166;
    public static final int H = 80;

    public CraftingMultiblockGui(Supplier<Boolean> isShapeValid, Supplier<Float> progressSupplier, CrafterComponent crafter, IntSupplier remainingOverclockTicks) {
        this.isShapeValid = isShapeValid;
        this.crafter = crafter;
        this.progressSupplier = progressSupplier;
        this.remainingOverclockTicks = remainingOverclockTicks;
    }

    @Override
    public Unit getParams() {
        return Unit.INSTANCE;
    }

    @Override
    public Data extractData() {
        boolean shapeValid = this.isShapeValid.get();
        Optional<RecipeData> activeRecipe = shapeValid && this.crafter.hasActiveRecipe() ? Optional.of(new RecipeData(this.progressSupplier.get().floatValue(), this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu())) : Optional.empty();
        return new Data(shapeValid, activeRecipe, this.remainingOverclockTicks.getAsInt());
    }

    @Override
    public GuiComponentServer.Type<Unit, Data> getType() {
        return TYPE;
    }

    public record RecipeData(float progress, int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu) {
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, RecipeData::progress, (StreamCodec)ByteBufCodecs.VAR_INT, RecipeData::efficiencyTicks, (StreamCodec)ByteBufCodecs.VAR_INT, RecipeData::maxEfficiencyTicks, (StreamCodec)ByteBufCodecs.VAR_LONG, RecipeData::currentRecipeEu, (StreamCodec)ByteBufCodecs.VAR_LONG, RecipeData::baseRecipeEu, RecipeData::new);
    }

    public record Data(boolean isShapeValid, Optional<RecipeData> activeRecipe, int remainingOverclockTicks) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Data::isShapeValid, (StreamCodec)ByteBufCodecs.optional(RecipeData.STREAM_CODEC), Data::activeRecipe, (StreamCodec)ByteBufCodecs.VAR_INT, Data::remainingOverclockTicks, Data::new);
    }
}

