/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AutoExtract
implements GuiComponentServer<Params, Data> {
    public static final GuiComponentServer.Type<Params, Data> TYPE = new GuiComponentServer.Type<Params, Data>(MI.id("auto_extract"), Params.STREAM_CODEC, Data.STREAM_CODEC);
    private final OrientationComponent orientation;
    private final Display display;

    public AutoExtract(OrientationComponent orientation, Display display) {
        this.orientation = orientation;
        this.display = display;
    }

    public AutoExtract(OrientationComponent orientation, boolean displayAsInsert) {
        this(orientation, displayAsInsert ? Display.INSERT : Display.EXTRACT);
    }

    public AutoExtract(OrientationComponent orientation) {
        this(orientation, false);
    }

    @Override
    public Params getParams() {
        return new Params(this.display, this.orientation.params.hasExtractItems, this.orientation.params.hasExtractFluids);
    }

    @Override
    public Data extractData() {
        return new Data(this.orientation.extractItems, this.orientation.extractFluids);
    }

    @Override
    public GuiComponentServer.Type<Params, Data> getType() {
        return TYPE;
    }

    public OrientationComponent getOrientation() {
        return this.orientation;
    }

    public static enum Display {
        EXTRACT,
        INSERT,
        BOTH;

    }

    public record Params(Display display, boolean hasExtractItems, boolean hasExtractFluids) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Display.class), Params::display, (StreamCodec)ByteBufCodecs.BOOL, Params::hasExtractItems, (StreamCodec)ByteBufCodecs.BOOL, Params::hasExtractFluids, Params::new);
    }

    public record Data(boolean extractItems, boolean extractFluids) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Data::extractItems, (StreamCodec)ByteBufCodecs.BOOL, Data::extractFluids, Data::new);
    }
}

