/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public class ActiveShapeComponent
implements MachineComponent {
    public final ShapeTemplate[] shapeTemplates;
    private int activeShape = 0;

    public ActiveShapeComponent(ShapeTemplate[] shapeTemplates) {
        this.shapeTemplates = shapeTemplates;
    }

    public void incrementShape(MultiblockMachineBlockEntity machine, int delta) {
        this.setShape(machine, Mth.clamp((int)(this.activeShape + delta), (int)0, (int)(this.shapeTemplates.length - 1)));
    }

    public void setShape(MultiblockMachineBlockEntity machine, int newShape) {
        if (newShape != this.activeShape) {
            this.activeShape = newShape;
            machine.setChanged();
            machine.unlink();
            machine.sync(false);
        }
    }

    public ShapeTemplate getActiveShape() {
        return this.shapeTemplates[this.activeShape];
    }

    public int getActiveShapeIndex() {
        return this.activeShape;
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("activeShape", this.activeShape);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.activeShape = tag.getInt("activeShape");
    }
}

