/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractElectricCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import net.minecraft.resources.ResourceLocation;

public class ElectricCraftingMultiblockBlockEntity
extends AbstractElectricCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private final MachineRecipeType recipeType;
    private final UpgradeComponent upgrades;
    private final OverdriveComponent overdrive;

    public ElectricCraftingMultiblockBlockEntity(BEP bep, ResourceLocation blockId, ShapeTemplate shapeTemplate, MachineRecipeType recipeType) {
        super(bep, blockId, new OrientationComponent.Params(false, false, false), new ShapeTemplate[]{shapeTemplate});
        this.recipeType = recipeType;
        this.upgrades = new UpgradeComponent();
        this.overdrive = new OverdriveComponent();
        this.registerComponents(this.upgrades, this.overdrive);
        this.registerGuiComponent(new SlotPanel(this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withOverdrive(this.overdrive));
    }

    public ElectricCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, MachineRecipeType recipeType) {
        this(bep, MI.id(name), shapeTemplate, recipeType);
    }

    @Override
    public MachineRecipeType recipeType() {
        return this.recipeType;
    }

    @Override
    public long getBaseRecipeEu() {
        return MachineTier.MULTIBLOCK.getBaseEu();
    }

    @Override
    public long getMaxRecipeEu() {
        return (long)MachineTier.MULTIBLOCK.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    @Override
    public boolean isOverdriving() {
        return this.overdrive.shouldOverdrive();
    }
}

