/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public sealed class ComponentStorage<C>
implements Iterable<C> {
    protected final List<C> components = new ArrayList<C>();

    @Override
    public Iterator<C> iterator() {
        return this.components.iterator();
    }

    @SafeVarargs
    public final void register(C ... components) {
        Collections.addAll(this.components, components);
    }

    @SafeVarargs
    public final void unregister(C ... components) {
        for (C component : components) {
            this.components.remove(component);
        }
    }

    public final int size() {
        return this.components.size();
    }

    public final C get(int index) {
        return this.components.get(index);
    }

    public final void forEachIndexed(BiConsumer<Integer, C> action) {
        for (int i = 0; i < this.components.size(); ++i) {
            action.accept(i, this.components.get(i));
        }
    }

    public final <T> @Nullable T getNullable(Class<T> clazz) {
        for (C component : this.components) {
            if (!clazz.isInstance(component)) continue;
            return (T)component;
        }
        return null;
    }

    public final <T> T getOrThrow(Class<T> clazz) {
        T ret = this.getNullable(clazz);
        if (ret == null) {
            throw new RuntimeException("Component not found: " + String.valueOf(clazz));
        }
        return ret;
    }

    public final <T> List<T> getAll(Class<T> clazz) {
        ArrayList<C> components = new ArrayList<C>();
        for (C component : this.components) {
            if (!clazz.isInstance(component)) continue;
            components.add(component);
        }
        return components;
    }

    public final <T> void forType(Class<T> clazz, Consumer<? super T> action) {
        List<T> component = this.getAll(clazz);
        for (T c : component) {
            action.accept(c);
        }
    }

    public final <T, R> R mapOrDefault(Class<T> clazz, Function<? super T, ? extends R> action, R defaultValue) {
        List<T> components = this.getAll(clazz);
        if (components.isEmpty()) {
            return defaultValue;
        }
        if (components.size() == 1) {
            return action.apply(components.get(0));
        }
        throw new RuntimeException("Multiple components of type " + clazz.getName() + " found");
    }

    public static final class Server
    extends ComponentStorage<MachineComponent> {
    }

    public static final class GuiServer
    extends ComponentStorage<GuiComponentServer<?, ?>> {
    }
}

