/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;

public class WaxItem
extends HoneycombItem {
    private static final ResourceLocation WAX_ON = ResourceLocation.withDefaultNamespace((String)"husbandry/wax_on");

    public WaxItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player;
        InteractionResult ret = super.useOn(context);
        if (ret.indicateItemUse() && (player = context.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WaxItem.grantWaxOn(serverPlayer);
        }
        return ret;
    }

    private static void grantWaxOn(ServerPlayer serverPlayer) {
        AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(WAX_ON);
        if (advancement == null) {
            return;
        }
        PlayerAdvancements playerAdvancements = serverPlayer.server.getPlayerList().getPlayerAdvancements(serverPlayer);
        playerAdvancements.award(advancement, "wax_on");
    }
}

