/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.api.machine.component.ItemAccess;
import aztech.modern_industrialization.compat.viewer.ReiDraggable;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jspecify.annotations.Nullable;

public class ConfigurableItemStack
extends AbstractConfigurableStack<Item, ItemVariant>
implements ItemAccess {
    private int adjustedCapacity = 64;

    public ConfigurableItemStack() {
    }

    public ConfigurableItemStack(CompoundTag compound, HolderLookup.Provider registries) {
        super(compound, registries);
        this.adjustedCapacity = compound.getInt("adjCap");
    }

    @Override
    public CompoundTag toNbt(HolderLookup.Provider registries) {
        CompoundTag nbt = super.toNbt(registries);
        nbt.putInt("adjCap", this.adjustedCapacity);
        return nbt;
    }

    public static ConfigurableItemStack standardInputSlot() {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.playerInsert = true;
        stack.pipesInsert = true;
        return stack;
    }

    public static ConfigurableItemStack standardOutputSlot() {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.pipesExtract = true;
        return stack;
    }

    public static ConfigurableItemStack standardIOSlot(boolean pipeIO) {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.playerInsert = true;
        if (pipeIO) {
            stack.pipesInsert = true;
            stack.pipesExtract = true;
        }
        return stack;
    }

    public static ConfigurableItemStack lockedInputSlot(Item item) {
        ConfigurableItemStack stack = new ConfigurableItemStack();
        stack.key = ItemVariant.of((ItemLike)item);
        stack.lockedInstance = item;
        stack.playerInsert = true;
        stack.playerLockable = false;
        stack.playerLocked = true;
        stack.pipesInsert = true;
        return stack;
    }

    public ConfigurableItemStack(ConfigurableItemStack other) {
        super(other);
        this.adjustedCapacity = other.adjustedCapacity;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurableItemStack that = (ConfigurableItemStack)o;
        return this.adjustedCapacity == that.adjustedCapacity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.adjustedCapacity);
    }

    @Override
    protected ItemVariant getBlankVariant() {
        return ItemVariant.blank();
    }

    @Override
    protected Item getEmptyInstance() {
        return Items.AIR;
    }

    @Override
    protected Registry<Item> getRegistry() {
        return BuiltInRegistries.ITEM;
    }

    @Override
    protected ItemVariant readVariantFromNbt(CompoundTag compound, HolderLookup.Provider registries) {
        return ItemVariant.fromNbt(compound, registries);
    }

    @Override
    public long getCapacity() {
        return ((ItemVariant)this.key).isBlank() ? (long)this.adjustedCapacity : (long)Math.min(this.adjustedCapacity, ((ItemVariant)this.key).getMaxStackSize());
    }

    @Override
    public long getRemainingCapacityFor(ItemVariant key) {
        if ((long)this.adjustedCapacity < this.amount) {
            return 0L;
        }
        return (long)Math.min(key.getMaxStackSize(), this.adjustedCapacity) - this.amount;
    }

    @Override
    public long getTotalCapacityFor(Item instance) {
        return Math.min(ItemVariant.of((ItemLike)instance).getMaxStackSize(), this.adjustedCapacity);
    }

    public static ArrayList<ConfigurableItemStack> copyList(List<ConfigurableItemStack> list) {
        ArrayList<ConfigurableItemStack> copy = new ArrayList<ConfigurableItemStack>(list.size());
        for (ConfigurableItemStack stack : list) {
            copy.add(new ConfigurableItemStack(stack));
        }
        return copy;
    }

    public boolean isValid(ItemStack stack) {
        return this.isResourceAllowedByLock(stack.getItem());
    }

    public void adjustCapacity(boolean isIncrease, boolean isShiftDown) {
        int delta;
        int n = delta = isShiftDown ? 8 : 1;
        if (!isIncrease) {
            delta = -delta;
        }
        this.adjustedCapacity = Mth.clamp((int)(this.adjustedCapacity + delta), (int)0, (int)64);
        this.notifyListeners();
    }

    public int getAdjustedCapacity() {
        return this.adjustedCapacity;
    }

    @Override
    public ItemVariant getVariant() {
        return (ItemVariant)this.getResource();
    }

    public class ConfigurableItemSlot
    extends HackySlot
    implements ReiDraggable,
    BackgroundRenderedSlot {
        private final Predicate<ItemStack> insertPredicate;
        private final Runnable markDirty;

        public ConfigurableItemSlot(ConfigurableItemSlot other) {
            this(other.markDirty, other.x, other.y, other.insertPredicate);
            this.index = other.index;
        }

        public ConfigurableItemSlot(Runnable markDirty, int x, int y, Predicate<ItemStack> insertPredicate) {
            super(x, y);
            this.insertPredicate = insertPredicate;
            this.markDirty = markDirty;
        }

        public boolean mayPlace(ItemStack stack) {
            return ConfigurableItemStack.this.playerInsert && ConfigurableItemStack.this.isValid(stack) && this.insertPredicate.test(stack);
        }

        public boolean mayPickup(Player playerEntity) {
            return ConfigurableItemStack.this.playerExtract;
        }

        public ConfigurableItemStack getConfStack() {
            return ConfigurableItemStack.this;
        }

        @Override
        protected ItemStack getRealStack() {
            return ((ItemVariant)ConfigurableItemStack.this.key).toStack((int)ConfigurableItemStack.this.amount);
        }

        @Override
        protected void setRealStack(ItemStack stack) {
            ConfigurableItemStack.this.key = ItemVariant.of(stack);
            ConfigurableItemStack.this.amount = stack.getCount();
            ConfigurableItemStack.this.notifyListeners();
            this.markDirty.run();
        }

        public int getMaxStackSize() {
            return ConfigurableItemStack.this.adjustedCapacity;
        }

        @Override
        public boolean dragFluid(FluidVariant fluidKey, Simulation simulation) {
            return false;
        }

        @Override
        public boolean dragItem(ItemVariant itemKey, Simulation simulation) {
            return ConfigurableItemStack.this.playerLock(itemKey.getItem(), simulation);
        }

        @Override
        public int getBackgroundU() {
            return ConfigurableItemStack.this.isPlayerLocked() ? 72 : (ConfigurableItemStack.this.isMachineLocked() ? 108 : 0);
        }
    }
}

